/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class FileEventStream
implements EventStream {
    BufferedReader reader;
    String line;

    public FileEventStream(String fileName, String encoding) throws IOException {
        this.reader = encoding == null ? new BufferedReader(new FileReader(fileName)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
    }

    public FileEventStream(String fileName) throws IOException {
        this(fileName, null);
    }

    public FileEventStream(File file) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
    }

    public boolean hasNext() {
        try {
            this.line = this.reader.readLine();
            return this.line != null;
        }
        catch (IOException e) {
            System.err.println(e);
            return false;
        }
    }

    public Event nextEvent() {
        StringTokenizer st = new StringTokenizer(this.line);
        String outcome = st.nextToken();
        int count2 = st.countTokens();
        String[] context = new String[count2];
        int ci = 0;
        while (ci < count2) {
            context[ci] = st.nextToken();
            ++ci;
        }
        return new Event(outcome, context);
    }

    public static String toLine(Event event) {
        StringBuffer sb = new StringBuffer();
        sb.append(event.getOutcome());
        String[] context = event.getContext();
        int ci = 0;
        int cl = context.length;
        while (ci < cl) {
            sb.append(" " + context[ci]);
            ++ci;
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: FileEventStream eventfile [iterations cutoff]");
            System.exit(1);
        }
        int ai = 0;
        String eventFile = args[ai++];
        FileEventStream es = new FileEventStream(eventFile);
        int iterations = 100;
        int cutoff = 5;
        if (ai < args.length) {
            iterations = Integer.parseInt(args[ai++]);
            cutoff = Integer.parseInt(args[ai++]);
        }
        GISModel model = GIS.trainModel(es, iterations, cutoff);
        new SuffixSensitiveGISModelWriter(model, new File(String.valueOf(eventFile) + ".bin.gz")).persist();
    }
}

