/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.DataIndexer;

public abstract class AbstractDataIndexer
implements DataIndexer {
    protected int[][] contexts;
    protected int[] outcomeList;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected String[] outcomeLabels;
    protected int[] predCounts;

    public int[][] getContexts() {
        return this.contexts;
    }

    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    public String[] getPredLabels() {
        return this.predLabels;
    }

    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    public int[] getPredCounts() {
        return this.predCounts;
    }

    protected int sortAndMerge(List eventsToCompare) {
        Collections.sort(eventsToCompare);
        int numEvents = eventsToCompare.size();
        int numUniqueEvents = 1;
        if (numEvents <= 1) {
            return numUniqueEvents;
        }
        ComparableEvent ce = (ComparableEvent)eventsToCompare.get(0);
        int i = 1;
        while (i < numEvents) {
            ComparableEvent ce2 = (ComparableEvent)eventsToCompare.get(i);
            if (ce.compareTo(ce2) == 0) {
                ++ce.seen;
                eventsToCompare.set(i, null);
            } else {
                ce = ce2;
                ++numUniqueEvents;
            }
            ++i;
        }
        System.out.println("done. Reduced " + numEvents + " events to " + numUniqueEvents + ".");
        this.contexts = new int[numUniqueEvents][];
        this.outcomeList = new int[numUniqueEvents];
        this.numTimesEventsSeen = new int[numUniqueEvents];
        i = 0;
        int j = 0;
        while (i < numEvents) {
            ComparableEvent evt = (ComparableEvent)eventsToCompare.get(i);
            if (evt != null) {
                this.numTimesEventsSeen[j] = evt.seen;
                this.outcomeList[j] = evt.outcome;
                this.contexts[j] = evt.predIndexes;
                ++j;
            }
            ++i;
        }
        return numUniqueEvents;
    }

    protected static void update(String[] ec, Set predicateSet, TObjectIntHashMap counter, int cutoff) {
        int j = 0;
        while (j < ec.length) {
            if (!counter.increment(ec[j])) {
                counter.put(ec[j], 1);
            }
            if (!predicateSet.contains(ec[j]) && counter.get(ec[j]) >= cutoff) {
                predicateSet.add(ec[j]);
            }
            ++j;
        }
    }

    protected static String[] toIndexedStringArray(TObjectIntHashMap labelToIndexMap) {
        final String[] array = new String[labelToIndexMap.size()];
        labelToIndexMap.forEachEntry(new TObjectIntProcedure(){

            public boolean execute(Object str, int index) {
                array[index] = (String)str;
                return true;
            }
        });
        return array;
    }

    public float[][] getValues() {
        return null;
    }
}

