/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Locale;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.MalformedURIException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.xinclude.BadEncodingAttributeException;
import nu.xom.xinclude.BadHTTPHeaderException;
import nu.xom.xinclude.BadHrefAttributeException;
import nu.xom.xinclude.BadParseAttributeException;
import nu.xom.xinclude.EncodingHeuristics;
import nu.xom.xinclude.InclusionLoopException;
import nu.xom.xinclude.MisplacedFallbackException;
import nu.xom.xinclude.NoIncludeLocationException;
import nu.xom.xinclude.XIncludeException;
import nu.xom.xinclude.XPointer;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

public class XIncluder {
    private static String version = System.getProperty("java.version");
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";

    private XIncluder() {
    }

    public static Document resolve(Document document2) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Builder builder = new Builder();
        return XIncluder.resolve(document2, builder);
    }

    public static Document resolve(Document document2, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Document document3 = new Document(document2);
        XIncluder.resolveInPlace(document3, builder);
        return document3;
    }

    public static void resolveInPlace(Document document2) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        XIncluder.resolveInPlace(document2, new Builder());
    }

    public static void resolveInPlace(Document document2, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        ArrayList arrayList = new ArrayList();
        XIncluder.resolveInPlace(document2, builder, arrayList);
    }

    private static void resolveInPlace(Document document2, Builder builder, ArrayList arrayList) throws IOException, ParsingException, XIncludeException {
        String string2 = document2.getBaseURI();
        if (string2 != null && string2.startsWith("file:///")) {
            string2 = "file:/" + string2.substring(8);
        }
        arrayList.add(string2);
        Element element = document2.getRootElement();
        XIncluder.resolve(element, builder, arrayList);
        arrayList.remove(arrayList.size() - 1);
    }

    private static void resolve(Element element, Builder builder, ArrayList arrayList) throws IOException, ParsingException, XIncludeException {
        XIncluder.resolve(element, builder, arrayList, null);
    }

    private static void resolve(Element element, Builder builder, ArrayList arrayList, Document document2) throws IOException, ParsingException, XIncludeException {
        block37: {
            if (XIncluder.isIncludeElement(element)) {
                XIncluder.verifyIncludeElement(element);
                String string2 = element.getAttributeValue("parse");
                if (string2 == null) {
                    string2 = "xml";
                }
                String string3 = element.getAttributeValue("xpointer");
                String string4 = element.getAttributeValue("encoding");
                String string5 = element.getAttributeValue("href");
                if ("".equals(string5)) {
                    string5 = null;
                }
                ParentNode parentNode = element.getParent();
                String string6 = element.getBaseURI();
                URL uRL = null;
                try {
                    uRL = new URL(string6);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                URL uRL2 = null;
                try {
                    if (uRL != null && string5 != null) {
                        uRL2 = XIncluder.absolutize(uRL, string5);
                    } else if (string5 != null) {
                        try {
                            XIncluder.testURISyntax(string5);
                            uRL2 = new URL(string5);
                        }
                        catch (MalformedURIException malformedURIException) {
                            if (uRL == null) {
                                throw new BadHrefAttributeException("Could not resolve relative URI " + string5 + " because the xi:include element does" + " not have a base URI.", string5);
                            }
                            throw new BadHrefAttributeException("Illegal IRI in href attribute", string5);
                        }
                    }
                    String string7 = element.getAttributeValue("accept");
                    XIncluder.checkHeader(string7);
                    String string8 = element.getAttributeValue("accept-language");
                    XIncluder.checkHeader(string8);
                    if (string2.equals("xml")) {
                        Object object;
                        Node node;
                        Object object2;
                        int n;
                        Nodes nodes;
                        String string9 = "";
                        if (parentNode instanceof Element) {
                            string9 = XIncluder.getXMLLangValue((Element)parentNode);
                        }
                        if (uRL2 != null) {
                            nodes = XIncluder.downloadXMLDocument(uRL2, string3, builder, arrayList, string7, string8, string9);
                            for (n = 0; n < nodes.size(); ++n) {
                                object2 = nodes.get(n);
                                if (!(object2 instanceof Element)) continue;
                                String string10 = ((Node)object2).getBaseURI();
                                if (string10.indexOf(35) >= 0) {
                                    string10 = string10.substring(0, string10.indexOf(35));
                                }
                                node = (Element)object2;
                                object = parentNode.getBaseURI();
                                if (object != null && !"".equals(object)) {
                                    object = XIncluder.getDirectoryBase((String)object);
                                }
                                if (string10.startsWith((String)object)) {
                                    string10 = string10.substring(((String)object).length());
                                }
                                Attribute attribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string10);
                                ((Element)node).addAttribute(attribute);
                            }
                        } else {
                            Document document3 = element.getDocument();
                            if (document3 == null) {
                                document3 = document2;
                            }
                            object2 = XPointer.query(document3, string3);
                            nodes = new Nodes();
                            for (int i = 0; i < ((Nodes)object2).size(); ++i) {
                                node = ((Nodes)object2).get(i);
                                if (XIncluder.contains((Element)node, element)) {
                                    throw new InclusionLoopException("Element tried to include itself");
                                }
                                object = node.copy();
                                nodes.append((Node)object);
                            }
                            nodes = XIncluder.resolveXPointerSelection(nodes, builder, arrayList, document3);
                        }
                        if (parentNode instanceof Element) {
                            n = parentNode.indexOf(element);
                            for (int i = 0; i < nodes.size(); ++i) {
                                Node node2 = nodes.get(i);
                                parentNode.insertChild(node2, n + i);
                            }
                            element.detach();
                        } else {
                            Node node3;
                            Document document4 = (Document)parentNode;
                            int n2 = 0;
                            while (true) {
                                node3 = nodes.get(n2);
                                ++n2;
                                if (node3 instanceof Element) break;
                                document4.insertChild(node3, document4.indexOf(element));
                            }
                            document4.setRootElement((Element)node3);
                            node3 = document4.getRootElement();
                            int n3 = document4.indexOf(node3);
                            for (int i = n2; i < nodes.size(); ++i) {
                                document4.insertChild(nodes.get(i), n3 + 1 + i - n2);
                            }
                        }
                        break block37;
                    }
                    if (string2.equals("text")) {
                        Nodes nodes = XIncluder.downloadTextDocument(uRL2, string4, builder, string7, string8);
                        for (int i = 0; i < nodes.size(); ++i) {
                            Node node = nodes.get(i);
                            if (node instanceof Attribute) {
                                ((Element)parentNode).addAttribute((Attribute)node);
                                continue;
                            }
                            parentNode.insertChild(node, parentNode.indexOf(element));
                        }
                        parentNode.removeChild(element);
                        break block37;
                    }
                    throw new BadParseAttributeException("Bad value for parse attribute: " + string2, element.getDocument().getBaseURI());
                }
                catch (IOException iOException) {
                    XIncluder.processFallback(element, builder, arrayList, parentNode, iOException);
                }
                catch (XPointerSyntaxException xPointerSyntaxException) {
                    XIncluder.processFallback(element, builder, arrayList, parentNode, xPointerSyntaxException);
                }
                catch (XPointerResourceException xPointerResourceException) {
                    XIncluder.processFallback(element, builder, arrayList, parentNode, xPointerResourceException);
                }
            } else {
                if (XIncluder.isFallbackElement(element)) {
                    throw new MisplacedFallbackException("Fallback element outside include element", element.getDocument().getBaseURI());
                }
                Elements elements = element.getChildElements();
                for (int i = 0; i < elements.size(); ++i) {
                    XIncluder.resolve(elements.get(i), builder, arrayList);
                }
            }
        }
    }

    private static String getDirectoryBase(String string2) {
        if (string2.endsWith("/")) {
            return string2;
        }
        int n = string2.lastIndexOf(47);
        return string2.substring(0, n + 1);
    }

    private static void verifyIncludeElement(Element element) throws XIncludeException {
        XIncluder.testHref(element);
        XIncluder.testForFragmentIdentifier(element);
        XIncluder.verifyEncoding(element);
        XIncluder.testForForbiddenChildElements(element);
    }

    private static void testHref(Element element) throws NoIncludeLocationException {
        String string2 = element.getAttributeValue("href");
        String string3 = element.getAttributeValue("xpointer");
        if (string2 == null && string3 == null) {
            throw new NoIncludeLocationException("Missing href attribute", element.getDocument().getBaseURI());
        }
    }

    private static void testForFragmentIdentifier(Element element) throws BadHrefAttributeException {
        String string2 = element.getAttributeValue("href");
        if (string2 != null && string2.indexOf(35) > -1) {
            throw new BadHrefAttributeException("fragment identifier in URI " + string2, element.getBaseURI());
        }
    }

    private static void verifyEncoding(Element element) throws BadEncodingAttributeException {
        String string2 = element.getAttributeValue("encoding");
        if (string2 == null) {
            return;
        }
        char[] cArray = string2.toCharArray();
        if (cArray.length == 0) {
            throw new BadEncodingAttributeException("Empty encoding attribute", element.getBaseURI());
        }
        char c = cArray[0];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            throw new BadEncodingAttributeException("Illegal value for encoding attribute: " + string2, element.getBaseURI());
        }
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            throw new BadEncodingAttributeException("Illegal value for encoding attribute: " + string2, element.getBaseURI());
        }
    }

    private static URL absolutize(URL uRL, String string2) throws MalformedURLException, BadHrefAttributeException {
        Element element = new Element("c");
        String string3 = uRL.toExternalForm();
        element.setBaseURI(string3);
        Element element2 = new Element("c");
        element.appendChild(element2);
        element2.addAttribute(new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string2));
        URL uRL2 = new URL(element2.getBaseURI());
        if (!"".equals(string2) && uRL2.toExternalForm().equals(string3) && !uRL.toExternalForm().endsWith(string2)) {
            throw new BadHrefAttributeException(string2 + " is not a syntactically correct IRI");
        }
        return uRL2;
    }

    private static void testURISyntax(String string2) {
        Element element = new Element("e");
        element.setNamespaceURI(string2);
    }

    private static String getXMLLangValue(Element element) {
        Attribute attribute;
        while ((attribute = element.getAttribute("lang", "http://www.w3.org/XML/1998/namespace")) == null) {
            ParentNode parentNode = element.getParent();
            if (parentNode == null) {
                return "";
            }
            if (parentNode instanceof Document) {
                return "";
            }
            element = (Element)parentNode;
        }
        return attribute.getValue();
    }

    private static Nodes resolveXPointerSelection(Nodes nodes, Builder builder, ArrayList arrayList, Document document2) throws IOException, ParsingException, XIncludeException {
        Element element = (Element)nodes.get(0);
        return XIncluder.resolveSilently(element, builder, arrayList, document2);
    }

    private static boolean contains(ParentNode parentNode, Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
            if (node2 != parentNode) continue;
            return true;
        }
        return false;
    }

    private static Nodes resolveSilently(Element element, Builder builder, ArrayList arrayList, Document document2) throws IOException, ParsingException, XIncludeException {
        if (XIncluder.isIncludeElement(element) || XIncluder.isFallbackElement(element)) {
            throw new RuntimeException("XOM BUG: include or fallback element passed to resolveSilently; please report with a test case");
        }
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            XIncluder.resolve(elements.get(i), builder, arrayList, document2);
        }
        return new Nodes(element);
    }

    private static void testForForbiddenChildElements(Element element) throws XIncludeException {
        int n = 0;
        Elements elements = element.getChildElements();
        int n2 = elements.size();
        for (int i = 0; i < n2; ++i) {
            Element element2 = elements.get(i);
            if (!XINCLUDE_NS.equals(element2.getNamespaceURI())) continue;
            if ("fallback".equals(element2.getLocalName())) {
                if (++n <= 1) continue;
                throw new XIncludeException("Multiple fallback elements", element.getDocument().getBaseURI());
            }
            throw new XIncludeException("Include element contains an include child", element.getDocument().getBaseURI());
        }
    }

    private static void processFallback(Element element, Builder builder, ArrayList arrayList, ParentNode parentNode, Exception exception) throws XIncludeException, IOException, ParsingException {
        Element element2 = element.getFirstChildElement("fallback", XINCLUDE_NS);
        if (element2 == null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            XIncludeException xIncludeException = new XIncludeException(exception.getMessage(), element.getDocument().getBaseURI());
            xIncludeException.initCause(exception);
            throw xIncludeException;
        }
        while (element2.getChildCount() > 0) {
            Node node = element2.getChild(0);
            if (node instanceof Element) {
                XIncluder.resolve((Element)node, builder, arrayList);
            }
            node = element2.getChild(0);
            node.detach();
            parentNode.insertChild(node, parentNode.indexOf(element));
        }
        element.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Nodes downloadXMLDocument(URL uRL, String string2, Builder builder, ArrayList arrayList, String string3, String string4, String string5) throws IOException, ParsingException, XIncludeException, XPointerSyntaxException, XPointerResourceException {
        Object object;
        Node node;
        int n;
        Nodes nodes;
        Document document2;
        String string6 = uRL.toExternalForm();
        if (string2 == null && arrayList.indexOf(string6) != -1) {
            throw new InclusionLoopException("Tried to include the already included document " + string6 + " from " + arrayList.get(arrayList.size() - 1), (String)arrayList.get(arrayList.size() - 1));
        }
        URLConnection uRLConnection = uRL.openConnection();
        XIncluder.setHeaders(uRLConnection, string3, string4);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            document2 = builder.build(bufferedInputStream, uRL.toExternalForm());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        XIncluder.resolveInPlace(document2, builder, arrayList);
        if (string2 != null && string2.length() != 0) {
            nodes = XPointer.query(document2, string2);
            for (n = 0; n < nodes.size(); ++n) {
                String string7;
                node = nodes.get(n);
                object = (Element)node;
                Attribute attribute = ((Element)object).getAttribute("lang", "http://www.w3.org/XML/1998/namespace");
                if (attribute != null || string5.equals(string7 = XIncluder.getXMLLangValue((Element)object))) continue;
                ((Element)object).addAttribute(new Attribute("xml:lang", "http://www.w3.org/XML/1998/namespace", string7));
            }
        } else {
            nodes = new Nodes();
            for (n = 0; n < document2.getChildCount(); ++n) {
                node = document2.getChild(n);
                if (node instanceof DocType) continue;
                nodes.append(node);
            }
        }
        document2.setRootElement(new Element("f"));
        for (n = 0; n < nodes.size(); ++n) {
            node = nodes.get(n);
            object = node.getBaseURI();
            if (((String)object).indexOf(35) >= 0) {
                object = ((String)object).substring(0, ((String)object).indexOf(35));
            }
            node.detach();
            if (!(node instanceof Element)) continue;
            ((Element)node).setBaseURI((String)object);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Nodes downloadTextDocument(URL uRL, String string2, Builder builder, String string3, String string4) throws IOException, XIncludeException {
        if (string2 == null || string2.length() == 0) {
            string2 = "UTF-8";
        }
        URLConnection uRLConnection = uRL.openConnection();
        XIncluder.setHeaders(uRLConnection, string3, string4);
        String string5 = uRLConnection.getContentEncoding();
        String string6 = uRLConnection.getContentType();
        int n = uRLConnection.getContentLength();
        if (n < 0) {
            n = 1024;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            if (string5 != null) {
                string2 = string5;
            } else if (string6 != null && ((string6 = string6.toLowerCase(Locale.ENGLISH)).equals("text/xml") || string6.equals("application/xml") || string6.startsWith("text/") && string6.endsWith("+xml") || string6.startsWith("application/") && string6.endsWith("+xml"))) {
                string2 = EncodingHeuristics.readEncodingFromStream(bufferedInputStream);
            }
            if (version.startsWith("1.2") || version.startsWith("1.1")) {
                if (string2.equalsIgnoreCase("UTF-16")) {
                    ((InputStream)bufferedInputStream).mark(2);
                    int n2 = ((InputStream)bufferedInputStream).read();
                    string2 = n2 == 255 ? "UnicodeLittle" : "UnicodeBig";
                    ((InputStream)bufferedInputStream).reset();
                } else if (string2.equalsIgnoreCase("UnicodeBigUnmarked")) {
                    string2 = "UnicodeBig";
                } else if (string2.equalsIgnoreCase("UnicodeLittleUnmarked")) {
                    string2 = "UnicodeLittle";
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string2));
            StringBuffer stringBuffer = new StringBuffer(n);
            int n3 = ((Reader)bufferedReader).read();
            while (n3 != -1) {
                stringBuffer.append((char)n3);
                n3 = ((Reader)bufferedReader).read();
            }
            NodeFactory nodeFactory = builder.getNodeFactory();
            if (nodeFactory != null) {
                Nodes nodes = nodeFactory.makeText(stringBuffer.toString());
                return nodes;
            }
            Nodes nodes = new Nodes(new Text(stringBuffer.toString()));
            return nodes;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    private static void setHeaders(URLConnection uRLConnection, String string2, String string3) throws BadHTTPHeaderException {
        if (string2 != null) {
            XIncluder.checkHeader(string2);
            uRLConnection.setRequestProperty("accept", string2);
        }
        if (string3 != null) {
            XIncluder.checkHeader(string3);
            uRLConnection.setRequestProperty("accept-language", string3);
        }
    }

    private static void checkHeader(String string2) throws BadHTTPHeaderException {
        if (string2 == null) {
            return;
        }
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            throw new BadHTTPHeaderException("Header contains illegal character 0x" + Integer.toHexString(c).toUpperCase());
        }
    }

    private static boolean isIncludeElement(Element element) {
        return element.getLocalName().equals("include") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }

    private static boolean isFallbackElement(Element element) {
        return element.getLocalName().equals("fallback") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }
}

