/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.tests;

import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class XOMTestCase
extends TestCase {
    public XOMTestCase(String string2) {
        super(string2);
    }

    public static void assertEquals(Text text2, Text text3) {
        XOMTestCase.assertEquals(null, text2, text3);
    }

    public static void assertEquals(String string2, Text text2, Text text3) {
        if (text3 == text2) {
            return;
        }
        XOMTestCase.nullCheck(string2, text2, text3);
        XOMTestCase.assertEquals((String)string2, (String)text2.getValue(), (String)text3.getValue());
    }

    private static void nullCheck(String string2, Node node, Node node2) {
        if (node == null) {
            throw new ComparisonFailure(string2, null, node2.toXML());
        }
        if (node2 == null) {
            throw new ComparisonFailure(string2, node.toXML(), null);
        }
    }

    public static void assertEquals(Attribute attribute, Attribute attribute2) {
        XOMTestCase.assertEquals(null, attribute, attribute2);
    }

    public static void assertEquals(String string2, Attribute attribute, Attribute attribute2) {
        if (attribute2 == attribute) {
            return;
        }
        XOMTestCase.nullCheck(string2, attribute, attribute2);
        String string3 = attribute.getValue();
        String string4 = attribute2.getValue();
        if ("xml:base".equals(attribute.getQualifiedName())) {
            if (string3.equals(string4)) {
                return;
            }
            if (string3.startsWith("../")) {
                XOMTestCase.assertTrue((String)string2, (boolean)string4.endsWith(string3.substring(2)));
            } else {
                XOMTestCase.assertTrue((String)string2, (string3.endsWith('/' + string4) || string4.endsWith('/' + string3) ? 1 : 0) != 0);
            }
        } else {
            XOMTestCase.assertEquals((String)string2, (String)string3, (String)string4);
            XOMTestCase.assertEquals((String)string2, (String)attribute.getLocalName(), (String)attribute2.getLocalName());
            XOMTestCase.assertEquals((String)string2, (String)attribute.getQualifiedName(), (String)attribute2.getQualifiedName());
            XOMTestCase.assertEquals((String)string2, (String)attribute.getNamespaceURI(), (String)attribute2.getNamespaceURI());
        }
    }

    public static void assertEquals(DocType docType, DocType docType2) {
        XOMTestCase.assertEquals(null, docType, docType2);
    }

    public static void assertEquals(String string2, DocType docType, DocType docType2) {
        if (docType2 == docType) {
            return;
        }
        XOMTestCase.nullCheck(string2, docType, docType2);
        XOMTestCase.assertEquals((String)string2, (String)docType.getPublicID(), (String)docType2.getPublicID());
        XOMTestCase.assertEquals((String)string2, (String)docType.getSystemID(), (String)docType2.getSystemID());
        XOMTestCase.assertEquals((String)string2, (String)docType.getRootElementName(), (String)docType2.getRootElementName());
    }

    public static void assertEquals(Element element, Element element2) {
        XOMTestCase.assertEquals(null, element, element2);
    }

    public static void assertEquals(String string2, Element element, Element element2) {
        Object object;
        Object object2;
        int n;
        if (element2 == element) {
            return;
        }
        XOMTestCase.nullCheck(string2, element, element2);
        XOMTestCase.assertEquals((String)string2, (String)element.getLocalName(), (String)element2.getLocalName());
        XOMTestCase.assertEquals((String)string2, (String)element.getNamespacePrefix(), (String)element2.getNamespacePrefix());
        XOMTestCase.assertEquals((String)string2, (String)element.getNamespaceURI(), (String)element2.getNamespaceURI());
        XOMTestCase.assertEquals((String)string2, (int)element.getAttributeCount(), (int)element2.getAttributeCount());
        for (n = 0; n < element.getAttributeCount(); ++n) {
            object2 = element.getAttribute(n);
            object = element2.getAttribute(((Attribute)object2).getLocalName(), ((Attribute)object2).getNamespaceURI());
            XOMTestCase.assertNotNull((String)string2, (Object)object);
            XOMTestCase.assertEquals(string2, (Attribute)object2, (Attribute)object);
        }
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            object2 = element.getNamespacePrefix(n);
            object = element.getNamespaceURI((String)object2);
            XOMTestCase.assertNotNull((String)string2, (Object)element2.getNamespaceURI((String)object2));
            XOMTestCase.assertEquals((String)string2, (String)object, (String)element2.getNamespaceURI((String)object2));
        }
        for (n = 0; n < element2.getNamespaceDeclarationCount(); ++n) {
            object2 = element2.getNamespacePrefix(n);
            object = element2.getNamespaceURI((String)object2);
            XOMTestCase.assertNotNull((String)string2, (Object)element.getNamespaceURI((String)object2));
            XOMTestCase.assertEquals((String)string2, (String)object, (String)element.getNamespaceURI((String)object2));
        }
        XOMTestCase.compareChildren(string2, element, element2);
    }

    private static boolean hasAdjacentTextNodes(Element element) {
        boolean bl = false;
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) {
                if (bl) {
                    return true;
                }
                if ("".equals(node.getValue())) {
                    return true;
                }
                bl = true;
                continue;
            }
            bl = false;
        }
        return false;
    }

    private static void compareChildren(String string2, Element element, Element element2) {
        int n;
        Element element3 = element;
        Element element4 = element2;
        if (XOMTestCase.hasAdjacentTextNodes(element)) {
            element3 = XOMTestCase.combineTextNodes(element);
        }
        if (XOMTestCase.hasAdjacentTextNodes(element2)) {
            element4 = XOMTestCase.combineTextNodes(element2);
        }
        int n2 = element3.getChildCount();
        XOMTestCase.assertEquals((String)string2, (int)n2, (int)element4.getChildCount());
        int n3 = n2;
        for (n = 0; n < n2; ++n) {
            Node node = element3.getChild(n);
            if (!(node instanceof Text)) continue;
            --n3;
            Node node2 = element4.getChild(n);
            XOMTestCase.assertEquals(string2, node, node2);
        }
        n = 0;
        int n4 = element.getChildCount();
        for (int i = 0; i < n4; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) continue;
            Node node3 = element2.getChild(n);
            ++n;
            while (node3 instanceof Text) {
                node3 = element2.getChild(n);
                ++n;
            }
            XOMTestCase.assertEquals(string2, node, node3);
        }
    }

    private static Element combineTextNodes(Element element) {
        Element element2 = new Element("a");
        Comment comment2 = new Comment("c");
        StringBuffer stringBuffer = new StringBuffer();
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) {
                if ("".equals(node.getValue())) continue;
                stringBuffer.setLength(0);
                do {
                    stringBuffer.append(node.getValue());
                } while (++i != n && (node = element.getChild(i)) instanceof Text);
                --i;
                element2.appendChild(stringBuffer.toString());
                continue;
            }
            element2.appendChild(comment2.copy());
        }
        return element2;
    }

    public static void assertEquals(Document document2, Document document3) {
        XOMTestCase.assertEquals(null, document2, document3);
    }

    public static void assertEquals(String string2, Document document2, Document document3) {
        if (document3 == document2) {
            return;
        }
        XOMTestCase.nullCheck(string2, document2, document3);
        XOMTestCase.assertEquals((String)string2, (int)document2.getChildCount(), (int)document3.getChildCount());
        for (int i = 0; i < document3.getChildCount(); ++i) {
            Node node = document2.getChild(i);
            Node node2 = document3.getChild(i);
            XOMTestCase.assertEquals(string2, node, node2);
        }
    }

    public static void assertEquals(Comment comment2, Comment comment3) {
        XOMTestCase.assertEquals(null, comment2, comment3);
    }

    public static void assertEquals(String string2, Comment comment2, Comment comment3) {
        if (comment3 == comment2) {
            return;
        }
        XOMTestCase.nullCheck(string2, comment2, comment3);
        XOMTestCase.assertEquals((String)string2, (String)comment2.getValue(), (String)comment3.getValue());
    }

    public static void assertEquals(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        XOMTestCase.assertEquals(null, processingInstruction, processingInstruction2);
    }

    public static void assertEquals(String string2, ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        if (processingInstruction2 == processingInstruction) {
            return;
        }
        XOMTestCase.nullCheck(string2, processingInstruction, processingInstruction2);
        XOMTestCase.assertEquals((String)string2, (String)processingInstruction.getValue(), (String)processingInstruction2.getValue());
        XOMTestCase.assertEquals((String)string2, (String)processingInstruction.getTarget(), (String)processingInstruction2.getTarget());
    }

    public static void assertEquals(String string2, Namespace namespace, Namespace namespace2) {
        if (namespace2 == namespace) {
            return;
        }
        XOMTestCase.nullCheck(string2, namespace, namespace2);
        XOMTestCase.assertEquals((String)string2, (String)namespace.getValue(), (String)namespace2.getValue());
        XOMTestCase.assertEquals((String)string2, (String)namespace.getPrefix(), (String)namespace2.getPrefix());
    }

    public static void assertEquals(Node node, Node node2) {
        XOMTestCase.assertEquals(null, node, node2);
    }

    public static void assertEquals(String string2, Node node, Node node2) {
        block11: {
            if (node2 == node) {
                return;
            }
            XOMTestCase.nullCheck(string2, node, node2);
            try {
                if (node instanceof Document) {
                    XOMTestCase.assertEquals(string2, (Document)node, (Document)node2);
                    break block11;
                }
                if (node instanceof Element) {
                    XOMTestCase.assertEquals(string2, (Element)node, (Element)node2);
                    break block11;
                }
                if (node instanceof Text) {
                    XOMTestCase.assertEquals(string2, (Text)node, (Text)node2);
                    break block11;
                }
                if (node instanceof DocType) {
                    XOMTestCase.assertEquals(string2, (DocType)node, (DocType)node2);
                    break block11;
                }
                if (node instanceof Comment) {
                    XOMTestCase.assertEquals(string2, (Comment)node, (Comment)node2);
                    break block11;
                }
                if (node instanceof ProcessingInstruction) {
                    XOMTestCase.assertEquals(string2, (ProcessingInstruction)node, (ProcessingInstruction)node2);
                    break block11;
                }
                if (node instanceof Attribute) {
                    XOMTestCase.assertEquals(string2, (Attribute)node, (Attribute)node2);
                    break block11;
                }
                if (node instanceof Namespace) {
                    XOMTestCase.assertEquals(string2, (Namespace)node, (Namespace)node2);
                    break block11;
                }
                throw new IllegalArgumentException("Unexpected node type " + node.getClass().getName());
            }
            catch (ClassCastException classCastException) {
                throw new ComparisonFailure(string2 + "; Mismatched node types: " + node.getClass().getName() + " != " + node2.getClass().getName(), node.toXML(), node2.toXML());
            }
        }
    }
}

