/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.saxpath.base;

import java.util.ArrayList;
import nu.xom.jaxen.saxpath.Axis;
import nu.xom.jaxen.saxpath.SAXPathException;
import nu.xom.jaxen.saxpath.XPathHandler;
import nu.xom.jaxen.saxpath.XPathSyntaxException;
import nu.xom.jaxen.saxpath.base.Token;
import nu.xom.jaxen.saxpath.base.TokenTypes;
import nu.xom.jaxen.saxpath.base.XPathLexer;
import nu.xom.jaxen.saxpath.helpers.DefaultXPathHandler;

public class XPathReader
implements nu.xom.jaxen.saxpath.XPathReader {
    private ArrayList tokens;
    private XPathLexer lexer;
    private XPathHandler handler;
    private static XPathHandler defaultHandler = new DefaultXPathHandler();

    public XPathReader() {
        this.setXPathHandler(defaultHandler);
    }

    public void setXPathHandler(XPathHandler xPathHandler) {
        this.handler = xPathHandler;
    }

    public XPathHandler getXPathHandler() {
        return this.handler;
    }

    public void parse(String string2) throws SAXPathException {
        this.setUpParse(string2);
        this.getXPathHandler().startXPath();
        this.expr();
        this.getXPathHandler().endXPath();
        if (this.LA(1) != -1) {
            XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
            throw xPathSyntaxException;
        }
        this.lexer = null;
        this.tokens = null;
    }

    void setUpParse(String string2) {
        this.tokens = new ArrayList();
        this.lexer = new XPathLexer(string2);
    }

    private void pathExpr() throws SAXPathException {
        this.getXPathHandler().startPathExpr();
        switch (this.LA(1)) {
            case 26: 
            case 29: {
                this.filterExpr();
                if (this.LA(1) != 12 && this.LA(1) != 13) break;
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Node-set expected");
                throw xPathSyntaxException;
            }
            case 23: 
            case 25: {
                this.filterExpr();
                if (this.LA(1) != 12 && this.LA(1) != 13) break;
                this.locationPath(false);
                break;
            }
            case 16: {
                if (this.LA(2) == 23 && !this.isNodeTypeName(this.LT(1)) || this.LA(2) == 19 && this.LA(4) == 23) {
                    this.filterExpr();
                    if (this.LA(1) != 12 && this.LA(1) != 13) break;
                    this.locationPath(false);
                    break;
                }
                this.locationPath(false);
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 17: {
                this.locationPath(false);
                break;
            }
            case 12: 
            case 13: {
                this.locationPath(true);
                break;
            }
            default: {
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
                throw xPathSyntaxException;
            }
        }
        this.getXPathHandler().endPathExpr();
    }

    private void literal() throws SAXPathException {
        Token token2 = this.match(26);
        this.getXPathHandler().literal(token2.getTokenText());
    }

    private void functionCall() throws SAXPathException {
        String string2 = null;
        String string3 = null;
        if (this.LA(2) == 19) {
            string2 = this.match(16).getTokenText();
            this.match(19);
        } else {
            string2 = "";
        }
        string3 = this.match(16).getTokenText();
        this.getXPathHandler().startFunction(string2, string3);
        this.match(23);
        this.arguments();
        this.match(24);
        this.getXPathHandler().endFunction();
    }

    private void arguments() throws SAXPathException {
        while (this.LA(1) != 24) {
            this.expr();
            if (this.LA(1) != 30) break;
            this.match(30);
        }
    }

    private void filterExpr() throws SAXPathException {
        this.getXPathHandler().startFilterExpr();
        switch (this.LA(1)) {
            case 29: {
                Token token2 = this.match(29);
                this.getXPathHandler().number(Double.parseDouble(token2.getTokenText()));
                break;
            }
            case 26: {
                this.literal();
                break;
            }
            case 23: {
                this.match(23);
                this.expr();
                this.match(24);
                break;
            }
            case 16: {
                this.functionCall();
                break;
            }
            case 25: {
                this.variableReference();
            }
        }
        this.predicates();
        this.getXPathHandler().endFilterExpr();
    }

    private void variableReference() throws SAXPathException {
        this.match(25);
        String string2 = null;
        String string3 = null;
        if (this.LA(2) == 19) {
            string2 = this.match(16).getTokenText();
            this.match(19);
        } else {
            string2 = "";
        }
        string3 = this.match(16).getTokenText();
        this.getXPathHandler().variableReference(string2, string3);
    }

    void locationPath(boolean bl) throws SAXPathException {
        switch (this.LA(1)) {
            case 12: 
            case 13: {
                if (bl) {
                    this.absoluteLocationPath();
                    break;
                }
                this.relativeLocationPath();
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.relativeLocationPath();
                break;
            }
            default: {
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
                throw xPathSyntaxException;
            }
        }
    }

    private void absoluteLocationPath() throws SAXPathException {
        this.getXPathHandler().startAbsoluteLocationPath();
        block0 : switch (this.LA(1)) {
            case 12: {
                this.match(12);
                switch (this.LA(1)) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.steps();
                    }
                }
                break;
            }
            case 13: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(13);
                switch (this.LA(1)) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.steps();
                        break block0;
                    }
                }
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Location path cannot end with //");
                throw xPathSyntaxException;
            }
        }
        this.getXPathHandler().endAbsoluteLocationPath();
    }

    private void relativeLocationPath() throws SAXPathException {
        this.getXPathHandler().startRelativeLocationPath();
        switch (this.LA(1)) {
            case 12: {
                this.match(12);
                break;
            }
            case 13: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(13);
            }
        }
        this.steps();
        this.getXPathHandler().endRelativeLocationPath();
    }

    private void steps() throws SAXPathException {
        switch (this.LA(1)) {
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.step();
                break;
            }
            case -1: {
                return;
            }
            default: {
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
                throw xPathSyntaxException;
            }
        }
        block11: while (true) {
            if (this.LA(1) == 12 || this.LA(1) == 13) {
                switch (this.LA(1)) {
                    case 12: {
                        this.match(12);
                        break;
                    }
                    case 13: {
                        this.getXPathHandler().startAllNodeStep(12);
                        this.getXPathHandler().endAllNodeStep();
                        this.match(13);
                    }
                }
            } else {
                return;
            }
            switch (this.LA(1)) {
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.step();
                    continue block11;
                }
            }
            break;
        }
        XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
        throw xPathSyntaxException;
    }

    void step() throws SAXPathException {
        int n = 0;
        switch (this.LA(1)) {
            case 14: 
            case 15: {
                this.abbrStep();
                return;
            }
            case 17: {
                n = this.axisSpecifier();
                break;
            }
            case 16: {
                if (this.LA(2) == 20) {
                    n = this.axisSpecifier();
                    break;
                }
                n = 1;
                break;
            }
            case 9: {
                n = 1;
            }
        }
        this.nodeTest(n);
    }

    private int axisSpecifier() throws SAXPathException {
        int n = 0;
        switch (this.LA(1)) {
            case 17: {
                this.match(17);
                n = 9;
                break;
            }
            case 16: {
                Token token2 = this.LT(1);
                n = Axis.lookup(token2.getTokenText());
                if (n == 0) {
                    this.throwInvalidAxis(token2.getTokenText());
                }
                this.match(16);
                this.match(20);
                break;
            }
        }
        return n;
    }

    private void nodeTest(int n) throws SAXPathException {
        block0 : switch (this.LA(1)) {
            case 16: {
                switch (this.LA(2)) {
                    case 23: {
                        this.nodeTypeTest(n);
                        break block0;
                    }
                }
                this.nameTest(n);
                break;
            }
            case 9: {
                this.nameTest(n);
                break;
            }
            default: {
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected <QName> or *");
                throw xPathSyntaxException;
            }
        }
    }

    private void nodeTypeTest(int n) throws SAXPathException {
        Token token2 = this.match(16);
        String string2 = token2.getTokenText();
        this.match(23);
        if ("processing-instruction".equals(string2)) {
            String string3 = "";
            if (this.LA(1) == 26) {
                string3 = this.match(26).getTokenText();
            }
            this.match(24);
            this.getXPathHandler().startProcessingInstructionNodeStep(n, string3);
            this.predicates();
            this.getXPathHandler().endProcessingInstructionNodeStep();
        } else if ("node".equals(string2)) {
            this.match(24);
            this.getXPathHandler().startAllNodeStep(n);
            this.predicates();
            this.getXPathHandler().endAllNodeStep();
        } else if ("text".equals(string2)) {
            this.match(24);
            this.getXPathHandler().startTextNodeStep(n);
            this.predicates();
            this.getXPathHandler().endTextNodeStep();
        } else if ("comment".equals(string2)) {
            this.match(24);
            this.getXPathHandler().startCommentNodeStep(n);
            this.predicates();
            this.getXPathHandler().endCommentNodeStep();
        } else {
            XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected node-type");
            throw xPathSyntaxException;
        }
    }

    private void nameTest(int n) throws SAXPathException {
        String string2 = null;
        String string3 = null;
        switch (this.LA(2)) {
            case 19: {
                switch (this.LA(1)) {
                    case 16: {
                        string2 = this.match(16).getTokenText();
                        this.match(19);
                    }
                }
            }
        }
        switch (this.LA(1)) {
            case 16: {
                string3 = this.match(16).getTokenText();
                break;
            }
            case 9: {
                this.match(9);
                string3 = "*";
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        this.getXPathHandler().startNameStep(n, string2, string3);
        this.predicates();
        this.getXPathHandler().endNameStep();
    }

    private void abbrStep() throws SAXPathException {
        switch (this.LA(1)) {
            case 14: {
                this.match(14);
                this.getXPathHandler().startAllNodeStep(11);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
                break;
            }
            case 15: {
                this.match(15);
                this.getXPathHandler().startAllNodeStep(3);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
            }
        }
    }

    private void predicates() throws SAXPathException {
        while (this.LA(1) == 21) {
            this.predicate();
        }
    }

    void predicate() throws SAXPathException {
        this.getXPathHandler().startPredicate();
        this.match(21);
        this.predicateExpr();
        this.match(22);
        this.getXPathHandler().endPredicate();
    }

    private void predicateExpr() throws SAXPathException {
        this.expr();
    }

    private void expr() throws SAXPathException {
        this.orExpr();
    }

    private void orExpr() throws SAXPathException {
        this.getXPathHandler().startOrExpr();
        this.andExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 28: {
                bl = true;
                this.match(28);
                this.orExpr();
            }
        }
        this.getXPathHandler().endOrExpr(bl);
    }

    private void andExpr() throws SAXPathException {
        this.getXPathHandler().startAndExpr();
        this.equalityExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 27: {
                bl = true;
                this.match(27);
                this.andExpr();
            }
        }
        this.getXPathHandler().endAndExpr(bl);
    }

    private void equalityExpr() throws SAXPathException {
        this.relationalExpr();
        int n = this.LA(1);
        while (n == 1 || n == 2) {
            switch (n) {
                case 1: {
                    this.match(1);
                    this.getXPathHandler().startEqualityExpr();
                    this.relationalExpr();
                    this.getXPathHandler().endEqualityExpr(1);
                    break;
                }
                case 2: {
                    this.match(2);
                    this.getXPathHandler().startEqualityExpr();
                    this.relationalExpr();
                    this.getXPathHandler().endEqualityExpr(2);
                }
            }
            n = this.LA(1);
        }
    }

    private void relationalExpr() throws SAXPathException {
        this.additiveExpr();
        int n = this.LA(1);
        while (n == 3 || n == 5 || n == 4 || n == 6) {
            switch (n) {
                case 3: {
                    this.match(3);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(3);
                    break;
                }
                case 5: {
                    this.match(5);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(5);
                    break;
                }
                case 6: {
                    this.match(6);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(6);
                    break;
                }
                case 4: {
                    this.match(4);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(4);
                }
            }
            n = this.LA(1);
        }
    }

    private void additiveExpr() throws SAXPathException {
        this.multiplicativeExpr();
        int n = this.LA(1);
        while (n == 7 || n == 8) {
            switch (n) {
                case 7: {
                    this.match(7);
                    this.getXPathHandler().startAdditiveExpr();
                    this.multiplicativeExpr();
                    this.getXPathHandler().endAdditiveExpr(7);
                    break;
                }
                case 8: {
                    this.match(8);
                    this.getXPathHandler().startAdditiveExpr();
                    this.multiplicativeExpr();
                    this.getXPathHandler().endAdditiveExpr(8);
                }
            }
            n = this.LA(1);
        }
    }

    private void multiplicativeExpr() throws SAXPathException {
        this.unaryExpr();
        int n = this.LA(1);
        while (n == 31 || n == 11 || n == 10) {
            switch (n) {
                case 9: 
                case 31: {
                    this.match(31);
                    this.getXPathHandler().startMultiplicativeExpr();
                    this.unaryExpr();
                    this.getXPathHandler().endMultiplicativeExpr(9);
                    break;
                }
                case 11: {
                    this.match(11);
                    this.getXPathHandler().startMultiplicativeExpr();
                    this.unaryExpr();
                    this.getXPathHandler().endMultiplicativeExpr(11);
                    break;
                }
                case 10: {
                    this.match(10);
                    this.getXPathHandler().startMultiplicativeExpr();
                    this.unaryExpr();
                    this.getXPathHandler().endMultiplicativeExpr(10);
                }
            }
            n = this.LA(1);
        }
    }

    private void unaryExpr() throws SAXPathException {
        switch (this.LA(1)) {
            case 8: {
                this.getXPathHandler().startUnaryExpr();
                this.match(8);
                this.unaryExpr();
                this.getXPathHandler().endUnaryExpr(12);
                break;
            }
            default: {
                this.unionExpr();
            }
        }
    }

    private void unionExpr() throws SAXPathException {
        this.getXPathHandler().startUnionExpr();
        this.pathExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 18: {
                this.match(18);
                bl = true;
                this.expr();
            }
        }
        this.getXPathHandler().endUnionExpr(bl);
    }

    private Token match(int n) throws XPathSyntaxException {
        this.LT(1);
        Token token2 = (Token)this.tokens.get(0);
        if (token2.getTokenType() == n) {
            this.tokens.remove(0);
            return token2;
        }
        XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected: " + TokenTypes.getTokenText(n));
        throw xPathSyntaxException;
    }

    private int LA(int n) {
        return this.LT(n).getTokenType();
    }

    private Token LT(int n) {
        if (this.tokens.size() <= n - 1) {
            for (int i = 0; i < n; ++i) {
                this.tokens.add(this.lexer.nextToken());
            }
        }
        return (Token)this.tokens.get(n - 1);
    }

    private boolean isNodeTypeName(Token token2) {
        String string2 = token2.getTokenText();
        return "node".equals(string2) || "comment".equals(string2) || "text".equals(string2) || "processing-instruction".equals(string2);
    }

    private XPathSyntaxException createSyntaxException(String string2) {
        String string3 = this.lexer.getXPath();
        int n = this.LT(1).getTokenBegin();
        return new XPathSyntaxException(string3, n, string2);
    }

    private void throwInvalidAxis(String string2) throws SAXPathException {
        String string3 = this.lexer.getXPath();
        int n = this.LT(1).getTokenBegin();
        String string4 = "Expected valid axis name instead of [" + string2 + "]";
        throw new XPathSyntaxException(string3, n, string4);
    }
}

