/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.URIUtil;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class XOMHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    protected Document document;
    protected String documentBaseURI;
    protected ParentNode parent;
    protected ParentNode current;
    protected ArrayList parents;
    protected boolean inProlog;
    protected boolean inDTD;
    protected int position;
    protected Locator locator;
    protected DocType doctype;
    protected StringBuffer internalDTDSubset;
    protected NodeFactory factory;
    boolean usingCrimson = false;
    protected String textString = null;
    protected StringBuffer buffer = null;
    protected boolean inExternalSubset = false;
    protected boolean inCDATA = false;
    protected boolean finishedCDATA = false;

    XOMHandler(NodeFactory nodeFactory) {
        this.factory = nodeFactory;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    Document getDocument() {
        return this.document;
    }

    void freeMemory() {
        this.document = null;
        this.parent = null;
        this.current = null;
        this.parents = null;
        this.locator = null;
        this.doctype = null;
        this.internalDTDSubset = null;
    }

    public void startDocument() {
        this.inDTD = false;
        this.document = this.factory.startMakingDocument();
        this.parent = this.document;
        this.current = this.document;
        this.parents = new ArrayList();
        this.parents.add(this.document);
        this.inProlog = true;
        this.position = 0;
        this.textString = null;
        this.doctype = null;
        if (this.locator != null) {
            this.documentBaseURI = this.locator.getSystemId();
            this.document.setBaseURI(this.documentBaseURI);
        }
        this.buffer = null;
    }

    public void endDocument() {
        this.factory.finishMakingDocument(this.document);
        this.parents.remove(this.parents.size() - 1);
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) {
        Element element;
        this.flushText();
        if (this.parent != this.document) {
            element = this.factory.startMakingElement(string4, string2);
        } else {
            element = this.factory.makeRootElement(string4, string2);
            if (element == null) {
                throw new NullPointerException("Factory failed to create root element.");
            }
            this.document.setRootElement(element);
            this.inProlog = false;
        }
        this.current = element;
        this.parents.add(element);
        if (element != null) {
            Object object;
            String string5;
            String string6;
            String string7;
            int n;
            String string8;
            if (this.parent != this.document) {
                this.parent.appendChild(element);
            }
            if (this.locator != null && (string8 = this.locator.getSystemId()) != null && !string8.equals(this.documentBaseURI)) {
                element.setActualBaseURI(string8);
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                string7 = attributes.getQName(n);
                if (string7.startsWith("xmlns:") || string7.equals("xmlns")) continue;
                string6 = attributes.getURI(n);
                string5 = attributes.getValue(n);
                object = this.factory.makeAttribute(string7, string6, string5, XOMHandler.convertStringToType(attributes.getType(n)));
                int n2 = 0;
                for (int i = 0; i < ((Nodes)object).size(); ++i) {
                    Node node = ((Nodes)object).get(i);
                    if (node.isAttribute()) {
                        this.factory.addAttribute(element, (Attribute)node);
                        continue;
                    }
                    this.factory.insertChild(element, node, n2++);
                }
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                string7 = attributes.getQName(n);
                if (string7.startsWith("xmlns:")) {
                    string6 = attributes.getValue(n);
                    if (string6.equals(object = element.getNamespaceURI(string5 = string7.substring(6))) || string5.equals(element.getNamespacePrefix())) continue;
                    element.addNamespaceDeclaration(string5, string6);
                    continue;
                }
                if (!string7.equals("xmlns") || (string6 = attributes.getValue(n)).equals(object = element.getNamespaceURI(string5 = "")) || "".equals(element.getNamespacePrefix())) continue;
                element.addNamespaceDeclaration(string5, string6);
            }
            this.parent = element;
        }
    }

    public void endElement(String string2, String string3, String string4) {
        this.current = (ParentNode)this.parents.remove(this.parents.size() - 1);
        this.flushText();
        if (this.current != null) {
            this.parent = this.current.getParent();
            Nodes nodes = this.factory.finishMakingElement((Element)this.current);
            if (nodes.size() != 1 || nodes.get(0) != this.current) {
                if (!this.parent.isDocument()) {
                    int n = this.parent.getChildCount();
                    try {
                        this.parent.removeChild(n - 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new XMLException("Factory detached element in finishMakingElement()", indexOutOfBoundsException);
                    }
                    for (int i = 0; i < nodes.size(); ++i) {
                        Node node = nodes.get(i);
                        if (node.isAttribute()) {
                            ((Element)this.parent).addAttribute((Attribute)node);
                            continue;
                        }
                        this.parent.appendChild(node);
                    }
                } else {
                    Document document2 = (Document)this.parent;
                    Element element = document2.getRootElement();
                    boolean bl = true;
                    for (int i = 0; i < nodes.size(); ++i) {
                        Node node = nodes.get(i);
                        if (node.isElement()) {
                            if (node != element) {
                                if (!bl) {
                                    throw new IllegalAddException("Factory returned multiple roots");
                                }
                                document2.setRootElement((Element)node);
                            }
                            bl = false;
                            continue;
                        }
                        if (bl) {
                            document2.insertChild(node, document2.indexOf(document2.getRootElement()));
                            continue;
                        }
                        document2.appendChild(node);
                    }
                    if (bl) {
                        throw new WellformednessException("Factory attempted to remove the root element");
                    }
                }
            }
        }
    }

    static Attribute.Type convertStringToType(String string2) {
        if (string2.equals("CDATA")) {
            return Attribute.Type.CDATA;
        }
        if (string2.equals("ID")) {
            return Attribute.Type.ID;
        }
        if (string2.equals("IDREF")) {
            return Attribute.Type.IDREF;
        }
        if (string2.equals("IDREFS")) {
            return Attribute.Type.IDREFS;
        }
        if (string2.equals("NMTOKEN")) {
            return Attribute.Type.NMTOKEN;
        }
        if (string2.equals("NMTOKENS")) {
            return Attribute.Type.NMTOKENS;
        }
        if (string2.equals("ENTITY")) {
            return Attribute.Type.ENTITY;
        }
        if (string2.equals("ENTITIES")) {
            return Attribute.Type.ENTITIES;
        }
        if (string2.equals("NOTATION")) {
            return Attribute.Type.NOTATION;
        }
        if (string2.equals("ENUMERATION")) {
            return Attribute.Type.ENUMERATION;
        }
        if (string2.startsWith("(")) {
            return Attribute.Type.ENUMERATION;
        }
        return Attribute.Type.UNDECLARED;
    }

    public void characters(char[] cArray, int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        if (this.textString == null) {
            this.textString = new String(cArray, n, n2);
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(this.textString);
            }
            this.buffer.append(cArray, n, n2);
        }
        if (this.finishedCDATA) {
            this.inCDATA = false;
        }
    }

    private void flushText() {
        if (this.buffer != null) {
            this.textString = this.buffer.toString();
            this.buffer = null;
        }
        if (this.textString != null) {
            Nodes nodes = !this.inCDATA ? this.factory.makeText(this.textString) : this.factory.makeCDATASection(this.textString);
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
            }
            this.textString = null;
        }
        this.inCDATA = false;
        this.finishedCDATA = false;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string2, String string3) {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes nodes = this.factory.makeProcessingInstruction(string2, string3);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isProcessingInstruction() || node.isComment()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    public void startPrefixMapping(String string2, String string3) {
    }

    public void endPrefixMapping(String string2) {
    }

    public void skippedEntity(String string2) {
        if (string2.startsWith("%")) {
            return;
        }
        this.flushText();
        throw new XMLException("Could not resolve entity " + string2);
    }

    public void startDTD(String string2, String string3, String string4) {
        this.inDTD = true;
        Nodes nodes = this.factory.makeDocType(string2, string3, string4);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            this.document.insertChild(node, this.position);
            ++this.position;
            if (!node.isDocType()) continue;
            DocType docType = (DocType)node;
            this.internalDTDSubset = new StringBuffer();
            this.doctype = docType;
        }
    }

    public void endDTD() {
        this.inDTD = false;
        if (this.doctype != null) {
            this.doctype.setInternalDTDSubset(this.internalDTDSubset.toString());
        }
    }

    public void startEntity(String string2) {
        if (string2.equals("[dtd]")) {
            this.inExternalSubset = true;
        }
    }

    public void endEntity(String string2) {
        if (string2.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }

    public void startCDATA() {
        if (this.textString == null) {
            this.inCDATA = true;
        }
        this.finishedCDATA = false;
    }

    public void endCDATA() {
        this.finishedCDATA = true;
    }

    public void comment(char[] cArray, int n, int n2) {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes nodes = this.factory.makeComment(new String(cArray, n, n2));
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node instanceof Attribute) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isComment() || node.isProcessingInstruction()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    public void elementDecl(String string2, String string3) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ELEMENT ");
            this.internalDTDSubset.append(string2);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string3);
            if (string3.indexOf("#PCDATA") > 0 && string3.indexOf(124) > 0 && string3.endsWith(")")) {
                this.internalDTDSubset.append('*');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    protected boolean inInternalSubset() {
        if (!this.usingCrimson) {
            return !this.inExternalSubset;
        }
        String string2 = this.locator.getSystemId();
        if (string2 == this.documentBaseURI) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        return string2.equals(this.documentBaseURI);
    }

    public void attributeDecl(String string2, String string3, String string4, String string5, String string6) {
        if (string4.startsWith("NOTATION ") && string4.indexOf(40) == -1 && !string4.endsWith(")")) {
            string4 = "NOTATION (" + string4.substring("NOTATION ".length()) + ")";
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ATTLIST ");
            this.internalDTDSubset.append(string2);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string3);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string4);
            if (string5 != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append(string5);
            }
            if (string6 != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append('\"');
                this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDefaultAttributeValues(string6));
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void internalEntityDecl(String string2, String string3) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string2.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(string2.substring(1));
            } else {
                this.internalDTDSubset.append(string2);
            }
            this.internalDTDSubset.append(" \"");
            this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDeclarations(string3));
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void externalEntityDecl(String string2, String string3, String string4) {
        if (this.inInternalSubset() && this.doctype != null) {
            String string5;
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string2.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(string2.substring(1));
            } else {
                this.internalDTDSubset.append(string2);
            }
            if (this.locator != null && URIUtil.isAbsolute(string4) && (string5 = this.locator.getSystemId()) != null) {
                if (string5.startsWith("file:/") && !string5.startsWith("file:///")) {
                    string5 = "file://" + string5.substring(5);
                }
                if (string4.startsWith("file:/") && !string4.startsWith("file:///")) {
                    string4 = "file://" + string4.substring(5);
                }
                string4 = URIUtil.relativize(string5, string4);
            }
            if (string3 != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(string4);
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string4);
            }
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void notationDecl(String string2, String string3, String string4) {
        if (string4 != null) {
            string4 = XOMHandler.escapeReservedCharactersInDeclarations(string4);
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!NOTATION ");
            this.internalDTDSubset.append(string2);
            if (string3 != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append('\"');
                if (string4 != null) {
                    this.internalDTDSubset.append(" \"");
                    this.internalDTDSubset.append(string4);
                    this.internalDTDSubset.append('\"');
                }
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string4);
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string3 != null) {
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(string4);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(string5);
            } else {
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string4);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(string5);
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    private static String escapeReservedCharactersInDeclarations(String string2) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block28: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block28;
                }
                case '\u000e': {
                    continue block28;
                }
                case '\u000f': {
                    continue block28;
                }
                case '\u0010': {
                    continue block28;
                }
                case '\u0011': {
                    continue block28;
                }
                case '\u0012': {
                    continue block28;
                }
                case '\u0013': {
                    continue block28;
                }
                case '\u0014': {
                    continue block28;
                }
                case '\u0015': {
                    continue block28;
                }
                case '\u0016': {
                    continue block28;
                }
                case '\u0017': {
                    continue block28;
                }
                case '\u0018': {
                    continue block28;
                }
                case '\u0019': {
                    continue block28;
                }
                case '\u001a': {
                    continue block28;
                }
                case '\u001b': {
                    continue block28;
                }
                case '\u001c': {
                    continue block28;
                }
                case '\u001d': {
                    continue block28;
                }
                case '\u001e': {
                    continue block28;
                }
                case '\u001f': {
                    continue block28;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    continue block28;
                }
                case '!': {
                    stringBuffer.append('!');
                    continue block28;
                }
                case '\"': {
                    stringBuffer.append("&#x22;");
                    continue block28;
                }
                case '#': {
                    stringBuffer.append('#');
                    continue block28;
                }
                case '$': {
                    stringBuffer.append('$');
                    continue block28;
                }
                case '%': {
                    stringBuffer.append("&#x25;");
                    continue block28;
                }
                case '&': {
                    stringBuffer.append("&#x26;");
                    continue block28;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String escapeReservedCharactersInDefaultAttributeValues(String string2) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block50: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block50;
                }
                case '\u000e': {
                    continue block50;
                }
                case '\u000f': {
                    continue block50;
                }
                case '\u0010': {
                    continue block50;
                }
                case '\u0011': {
                    continue block50;
                }
                case '\u0012': {
                    continue block50;
                }
                case '\u0013': {
                    continue block50;
                }
                case '\u0014': {
                    continue block50;
                }
                case '\u0015': {
                    continue block50;
                }
                case '\u0016': {
                    continue block50;
                }
                case '\u0017': {
                    continue block50;
                }
                case '\u0018': {
                    continue block50;
                }
                case '\u0019': {
                    continue block50;
                }
                case '\u001a': {
                    continue block50;
                }
                case '\u001b': {
                    continue block50;
                }
                case '\u001c': {
                    continue block50;
                }
                case '\u001d': {
                    continue block50;
                }
                case '\u001e': {
                    continue block50;
                }
                case '\u001f': {
                    continue block50;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    continue block50;
                }
                case '!': {
                    stringBuffer.append('!');
                    continue block50;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block50;
                }
                case '#': {
                    stringBuffer.append('#');
                    continue block50;
                }
                case '$': {
                    stringBuffer.append('$');
                    continue block50;
                }
                case '%': {
                    stringBuffer.append("&#x25;");
                    continue block50;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block50;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    continue block50;
                }
                case '(': {
                    stringBuffer.append('(');
                    continue block50;
                }
                case ')': {
                    stringBuffer.append(')');
                    continue block50;
                }
                case '*': {
                    stringBuffer.append('*');
                    continue block50;
                }
                case '+': {
                    stringBuffer.append('+');
                    continue block50;
                }
                case ',': {
                    stringBuffer.append(',');
                    continue block50;
                }
                case '-': {
                    stringBuffer.append('-');
                    continue block50;
                }
                case '.': {
                    stringBuffer.append('.');
                    continue block50;
                }
                case '/': {
                    stringBuffer.append('/');
                    continue block50;
                }
                case '0': {
                    stringBuffer.append('0');
                    continue block50;
                }
                case '1': {
                    stringBuffer.append('1');
                    continue block50;
                }
                case '2': {
                    stringBuffer.append('2');
                    continue block50;
                }
                case '3': {
                    stringBuffer.append('3');
                    continue block50;
                }
                case '4': {
                    stringBuffer.append('4');
                    continue block50;
                }
                case '5': {
                    stringBuffer.append('5');
                    continue block50;
                }
                case '6': {
                    stringBuffer.append('6');
                    continue block50;
                }
                case '7': {
                    stringBuffer.append('7');
                    continue block50;
                }
                case '8': {
                    stringBuffer.append('8');
                    continue block50;
                }
                case '9': {
                    stringBuffer.append('9');
                    continue block50;
                }
                case ':': {
                    stringBuffer.append(':');
                    continue block50;
                }
                case ';': {
                    stringBuffer.append(';');
                    continue block50;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block50;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

