/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import nu.xom.ASCIIWriter;
import nu.xom.GenericWriter;
import nu.xom.ISOArabicWriter;
import nu.xom.ISOCyrillicWriter;
import nu.xom.ISOGreekWriter;
import nu.xom.ISOHebrewWriter;
import nu.xom.ISOThaiWriter;
import nu.xom.Latin10Writer;
import nu.xom.Latin1Writer;
import nu.xom.Latin2Writer;
import nu.xom.Latin3Writer;
import nu.xom.Latin4Writer;
import nu.xom.Latin5Writer;
import nu.xom.Latin6Writer;
import nu.xom.Latin7Writer;
import nu.xom.Latin8Writer;
import nu.xom.Latin9Writer;
import nu.xom.TextWriter;
import nu.xom.UCSWriter;
import nu.xom.UnicodeWriter;

class TextWriterFactory {
    TextWriterFactory() {
    }

    public static TextWriter getTextWriter(Writer writer, String string2) {
        String string3 = string2.toUpperCase(Locale.ENGLISH);
        if (string3.startsWith("UTF") || string3.startsWith("UNICODE")) {
            return new UnicodeWriter(writer, string2);
        }
        if (string3.startsWith("ISO-10646-UCS") || string3.startsWith("UCS") || string3.equals("GB18030")) {
            return new UCSWriter(writer, string2);
        }
        if (string3.equals("ISO-8859-1")) {
            return new Latin1Writer(writer, string2);
        }
        if (string3.equals("ISO-8859-2")) {
            return new Latin2Writer(writer, string3);
        }
        if (string3.equals("ISO-8859-3")) {
            return new Latin3Writer(writer, string3);
        }
        if (string3.equals("ISO-8859-4")) {
            return new Latin4Writer(writer, string3);
        }
        if (string3.equals("ISO-8859-5")) {
            return new ISOCyrillicWriter(writer, string3);
        }
        if (string3.equals("ISO-8859-6")) {
            return new ISOArabicWriter(writer, string3);
        }
        if (string3.equals("ISO-8859-7")) {
            return new ISOGreekWriter(writer, string3);
        }
        if (string3.equals("ISO-8859-8")) {
            return new ISOHebrewWriter(writer, string3);
        }
        if (string3.equals("ISO-8859-9") || string3.equals("EBCDIC-CP-TR") || string3.equals("CP1037")) {
            return new Latin5Writer(writer, string3);
        }
        if (string2.equals("ISO-8859-10")) {
            return new Latin6Writer(writer, string2);
        }
        if (string3.equals("ISO-8859-11") || string3.equals("TIS-620") || string3.equals("TIS620")) {
            return new ISOThaiWriter(writer, string3);
        }
        if (string3.equals("ISO-8859-13")) {
            return new Latin7Writer(writer, string3);
        }
        if (string2.equals("ISO-8859-14")) {
            return new Latin8Writer(writer, string2);
        }
        if (string3.equals("ISO-8859-15")) {
            return new Latin9Writer(writer, string3);
        }
        if (string2.equals("ISO-8859-16")) {
            return new Latin10Writer(writer, string2);
        }
        if (string3.endsWith("ASCII")) {
            return new ASCIIWriter(writer, string3);
        }
        if (string3.equals("IBM037") || string3.equals("CP037") || string3.equals("EBCDIC-CP-US") || string3.equals("EBCDIC-CP-CA") || string3.equals("EBCDIC-CP-WA") || string3.equals("EBCDIC-CP-NL") || string3.equals("CSIBM037")) {
            return new Latin1Writer(writer, string3);
        }
        try {
            return new GenericWriter(writer, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ASCIIWriter(writer, string2);
        }
    }
}

