/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.NoSuchChildException;
import nu.xom.Node;
import nu.xom.Verifier;

public abstract class ParentNode
extends Node {
    Node[] children;
    int childCount = 0;
    String actualBaseURI;

    ParentNode() {
    }

    public int getChildCount() {
        return this.childCount;
    }

    public void insertChild(Node node, int n) {
        this._insertChild(node, n);
    }

    final void _insertChild(Node node, int n) {
        this.insertionAllowed(node, n);
        this.fastInsertChild(node, n);
    }

    void fastInsertChild(Node node, int n) {
        if (n > this.childCount) {
            throw new IndexOutOfBoundsException("Inserted node at position " + n + " after children");
        }
        this.checkCapacity(this.childCount + 1);
        if (n < this.childCount) {
            System.arraycopy(this.children, n, this.children, n + 1, this.childCount - n);
        }
        this.children[n] = node;
        ++this.childCount;
        node.setParent(this);
    }

    private void checkCapacity(int n) {
        if (this.children == null) {
            this.children = new Node[1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[this.children.length * 2];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
    }

    abstract void insertionAllowed(Node var1, int var2);

    public void appendChild(Node node) {
        this.insertChild(node, this.childCount);
    }

    public Node getChild(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        return this.children[n];
    }

    public int indexOf(Node node) {
        if (this.children == null) {
            return -1;
        }
        for (int i = 0; i < this.childCount; ++i) {
            if (node != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public Node removeChild(int n) {
        int n2;
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        Node node = this.children[n];
        if (node.isElement()) {
            this.fillInBaseURI((Element)node);
        }
        if ((n2 = this.childCount - n - 1) > 0) {
            System.arraycopy(this.children, n + 1, this.children, n, n2);
        }
        --this.childCount;
        this.children[this.childCount] = null;
        node.setParent(null);
        return node;
    }

    void fillInBaseURI(Element element) {
        String string2 = "";
        for (ParentNode parentNode = element; parentNode != null && string2.equals(""); parentNode = parentNode.getParent()) {
            string2 = parentNode.getActualBaseURI();
        }
        element.setActualBaseURI(string2);
    }

    public Node removeChild(Node node) {
        if (this.children == null) {
            throw new NoSuchChildException("Child does not belong to this node");
        }
        int n = this.indexOf(node);
        if (n == -1) {
            throw new NoSuchChildException("Child does not belong to this node");
        }
        if (node.isElement()) {
            this.fillInBaseURI((Element)node);
        }
        this.removeChild(n);
        node.setParent(null);
        return node;
    }

    public void replaceChild(Node node, Node node2) {
        if (node == null) {
            throw new NullPointerException("Tried to replace null child");
        }
        if (node2 == null) {
            throw new NullPointerException("Tried to replace child with null");
        }
        if (this.children == null) {
            throw new NoSuchChildException("Reference node is not a child of this node.");
        }
        int n = this.indexOf(node);
        if (n == -1) {
            throw new NoSuchChildException("Reference node is not a child of this node.");
        }
        if (node == node2) {
            return;
        }
        this.insertionAllowed(node2, n);
        this.removeChild(n);
        this.insertChild(node2, n);
    }

    public abstract void setBaseURI(String var1);

    String getActualBaseURI() {
        if (this.actualBaseURI == null) {
            return "";
        }
        return this.actualBaseURI;
    }

    void setActualBaseURI(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (!"".equals(string2)) {
            Verifier.checkAbsoluteURI(string2);
        }
        this.actualBaseURI = string2;
    }

    final String findActualBaseURI() {
        String string2;
        ParentNode parentNode = this;
        while (true) {
            string2 = parentNode.getActualBaseURI();
            ParentNode parentNode2 = parentNode.getParent();
            if (parentNode2 == null) {
                return string2;
            }
            if (!"".equals(string2)) break;
            parentNode = parentNode2;
        }
        return string2;
    }
}

