/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import nu.xom.Attribute;
import nu.xom.CycleException;
import nu.xom.Elements;
import nu.xom.IllegalAddException;
import nu.xom.IllegalNameException;
import nu.xom.MalformedURIException;
import nu.xom.MultipleParentException;
import nu.xom.NamespaceConflictException;
import nu.xom.Namespaces;
import nu.xom.NoSuchAttributeException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.URIUtil;
import nu.xom.Verifier;

public class Element
extends ParentNode {
    private String localName;
    private String prefix;
    private String URI;
    private Attribute[] attributes = null;
    private int numAttributes = 0;
    Namespaces namespaces = null;

    public Element(String string2) {
        this(string2, "");
    }

    public Element(String string2, String string3) {
        String string4 = "";
        String string5 = string2;
        int n = string2.indexOf(58);
        if (n > 0) {
            string4 = string2.substring(0, n);
            string5 = string2.substring(n + 1);
        }
        this._setNamespacePrefix(string4);
        this._setNamespaceURI(string3);
        try {
            this._setLocalName(string5);
        }
        catch (IllegalNameException illegalNameException) {
            illegalNameException.setData(string2);
            throw illegalNameException;
        }
    }

    private Element() {
    }

    static Element build(String string2, String string3, String string4) {
        Element element = new Element();
        String string5 = "";
        int n = string2.indexOf(58);
        if (n >= 0) {
            string5 = string2.substring(0, n);
        }
        element.prefix = string5;
        element.localName = string4;
        if (!"".equals(string3)) {
            Verifier.checkAbsoluteURIReference(string3);
        }
        element.URI = string3;
        return element;
    }

    public Element(Element element) {
        this.prefix = element.prefix;
        this.localName = element.localName;
        this.URI = element.URI;
        if (element.namespaces != null) {
            this.namespaces = element.namespaces.copy();
        }
        if (element.attributes != null) {
            this.attributes = element.copyAttributes(this);
            this.numAttributes = element.numAttributes;
        }
        this.actualBaseURI = element.findActualBaseURI();
        Element.copyChildren(element, this);
    }

    private Attribute[] copyAttributes(Element element) {
        if (this.numAttributes == 0) {
            return null;
        }
        Attribute[] attributeArray = new Attribute[this.numAttributes];
        for (int i = 0; i < this.numAttributes; ++i) {
            attributeArray[i] = (Attribute)this.attributes[i].copy();
            attributeArray[i].setParent(element);
        }
        return attributeArray;
    }

    private static Element copyTag(Element element) {
        Element element2 = element.shallowCopy();
        if (element.namespaces != null) {
            element2.namespaces = element.namespaces.copy();
        }
        if (element.attributes != null) {
            element2.attributes = element.copyAttributes(element2);
            element2.numAttributes = element.numAttributes;
        }
        element2.actualBaseURI = element.findActualBaseURI();
        return element2;
    }

    private static void copyChildren(Element element, Element element2) {
        if (element.getChildCount() == 0) {
            return;
        }
        Node node = element2;
        Node node2 = element;
        int n = 0;
        int[] nArray = new int[10];
        int n2 = 0;
        nArray[0] = 0;
        boolean bl = false;
        while (true) {
            Node node3;
            if (!bl && node2.getChildCount() > 0) {
                node2 = node2.getChild(0);
                n = 0;
                nArray = Element.grow(nArray, ++n2);
                nArray[n2] = 0;
            } else {
                bl = false;
                node3 = node2.getParent();
                if (node3.getChildCount() - 1 == n) {
                    node2 = node3;
                    --n2;
                    if (node2 == element) break;
                    node = (Element)node.getParent();
                    n = nArray[n2];
                    bl = true;
                    continue;
                }
                nArray[n2] = ++n;
                node2 = node3.getChild(n);
            }
            if (node2.isElement()) {
                node3 = Element.copyTag((Element)node2);
                node.appendChild(node3);
                if (node2.getChildCount() <= 0) continue;
                node = node3;
                continue;
            }
            node3 = node2.copy();
            node.appendChild(node3);
        }
    }

    private static int[] grow(int[] nArray, int n) {
        if (n < nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public final Elements getChildElements(String string2) {
        return this.getChildElements(string2, "");
    }

    public final Elements getChildElements(String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node node = this.getChild(i);
            if (!node.isElement() || !string2.equals((element = (Element)node).getLocalName()) && string2.length() != 0 || !string3.equals(element.getNamespaceURI())) continue;
            elements.add(element);
        }
        return elements;
    }

    public final Elements getChildElements() {
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node node = this.getChild(i);
            if (!node.isElement()) continue;
            Element element = (Element)node;
            elements.add(element);
        }
        return elements;
    }

    public final Element getFirstChildElement(String string2) {
        return this.getFirstChildElement(string2, "");
    }

    public final Element getFirstChildElement(String string2, String string3) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node node = this.getChild(i);
            if (!node.isElement() || !string2.equals((element = (Element)node).getLocalName()) || !string3.equals(element.getNamespaceURI())) continue;
            return element;
        }
        return null;
    }

    public void addAttribute(Attribute attribute) {
        Object object;
        if (attribute.getParent() != null) {
            throw new MultipleParentException("Attribute already has a parent");
        }
        String string2 = attribute.getNamespacePrefix();
        if (string2.length() != 0 && !"xml".equals(string2)) {
            if (this.prefix.equals(attribute.getNamespacePrefix()) && !this.getNamespaceURI().equals(attribute.getNamespaceURI())) {
                throw new NamespaceConflictException("Prefix of " + attribute.getQualifiedName() + " conflicts with element prefix " + this.prefix);
            }
            if (this.namespaces != null && (object = this.namespaces.getURI(attribute.getNamespacePrefix())) != null && !((String)object).equals(attribute.getNamespaceURI())) {
                throw new NamespaceConflictException("Attribute prefix  " + string2 + " conflicts with namespace declaration.");
            }
        }
        if (this.attributes == null) {
            this.attributes = new Attribute[1];
        }
        this.checkPrefixConflict(attribute);
        object = this.getAttribute(attribute.getLocalName(), attribute.getNamespaceURI());
        if (object != null) {
            this.remove((Attribute)object);
        }
        this.add(attribute);
        attribute.setParent(this);
    }

    private void add(Attribute attribute) {
        if (this.numAttributes == this.attributes.length) {
            Attribute[] attributeArray = new Attribute[this.attributes.length * 2];
            System.arraycopy(this.attributes, 0, attributeArray, 0, this.numAttributes);
            this.attributes = attributeArray;
        }
        this.attributes[this.numAttributes] = attribute;
        ++this.numAttributes;
    }

    private boolean remove(Attribute attribute) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.attributes.length; ++n) {
            if (this.attributes[n] != attribute) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return false;
        }
        n = this.numAttributes - n2 - 1;
        if (n > 0) {
            System.arraycopy(this.attributes, n2 + 1, this.attributes, n2, n);
        }
        --this.numAttributes;
        this.attributes[this.numAttributes] = null;
        return true;
    }

    void fastAddAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new Attribute[1];
        }
        this.add(attribute);
        attribute.setParent(this);
    }

    public Attribute removeAttribute(Attribute attribute) {
        if (this.attributes == null) {
            throw new NoSuchAttributeException("Tried to remove attribute " + attribute.getQualifiedName() + " from non-parent element");
        }
        if (attribute == null) {
            throw new NullPointerException("Tried to remove null attribute");
        }
        if (this.remove(attribute)) {
            attribute.setParent(null);
            return attribute;
        }
        throw new NoSuchAttributeException("Tried to remove attribute " + attribute.getQualifiedName() + " from non-parent element");
    }

    public final Attribute getAttribute(String string2) {
        return this.getAttribute(string2, "");
    }

    public final Attribute getAttribute(String string2, String string3) {
        if (this.attributes == null) {
            return null;
        }
        for (int i = 0; i < this.numAttributes; ++i) {
            Attribute attribute = this.attributes[i];
            if (!attribute.getLocalName().equals(string2) || !attribute.getNamespaceURI().equals(string3)) continue;
            return attribute;
        }
        return null;
    }

    public final String getAttributeValue(String string2) {
        return this.getAttributeValue(string2, "");
    }

    public final int getAttributeCount() {
        return this.numAttributes;
    }

    public final Attribute getAttribute(int n) {
        if (this.attributes == null) {
            throw new IndexOutOfBoundsException("Element does not have any attributes");
        }
        return this.attributes[n];
    }

    public final String getAttributeValue(String string2, String string3) {
        Attribute attribute = this.getAttribute(string2, string3);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespaceURI(String string2) {
        ParentNode parentNode;
        Element element = this;
        String string3 = this.getLocalNamespaceURI(string2);
        while (string3 == null && (parentNode = element.getParent()) != null && !parentNode.isDocument()) {
            element = (Element)parentNode;
            string3 = element.getLocalNamespaceURI(string2);
        }
        if (string3 == null && "".equals(string2)) {
            string3 = "";
        }
        return string3;
    }

    final String getLocalNamespaceURI(String string2) {
        String string3;
        if (string2.equals(this.prefix)) {
            return this.URI;
        }
        if ("xml".equals(string2)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string2)) {
            return "";
        }
        if (this.namespaces != null && (string3 = this.namespaces.getURI(string2)) != null) {
            return string3;
        }
        if (string2.length() != 0 && this.attributes != null) {
            for (int i = 0; i < this.numAttributes; ++i) {
                Attribute attribute = this.attributes[i];
                if (!attribute.getNamespacePrefix().equals(string2)) continue;
                return attribute.getNamespaceURI();
            }
        }
        return null;
    }

    public void setLocalName(String string2) {
        this._setLocalName(string2);
    }

    private void _setLocalName(String string2) {
        Verifier.checkNCName(string2);
        this.localName = string2;
    }

    public void setNamespaceURI(String string2) {
        this._setNamespaceURI(string2);
    }

    private void _setNamespaceURI(String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if (string2.equals(this.URI)) {
            return;
        }
        if (string2.length() == 0) {
            if (this.prefix.length() != 0) {
                throw new NamespaceConflictException("Prefixed elements must have namespace URIs.");
            }
        } else {
            Verifier.checkAbsoluteURIReference(string2);
        }
        if (this.namespaces != null && (string3 = this.namespaces.getURI(this.prefix)) != null) {
            throw new NamespaceConflictException("new URI conflicts with existing prefix");
        }
        if (string2.length() > 0 && this.attributes != null) {
            for (int i = 0; i < this.numAttributes; ++i) {
                Attribute attribute = this.attributes[i];
                String string4 = attribute.getNamespacePrefix();
                if (string4.length() == 0 || !attribute.getNamespacePrefix().equals(this.prefix)) continue;
                throw new NamespaceConflictException("new element URI " + string2 + " conflicts with attribute " + attribute.getQualifiedName());
            }
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string2) && !"xml".equals(this.prefix)) {
            throw new NamespaceConflictException("Wrong prefix " + this.prefix + " for the http://www.w3.org/XML/1998/namespace namespace URI");
        }
        if ("xml".equals(this.prefix) && !"http://www.w3.org/XML/1998/namespace".equals(string2)) {
            throw new NamespaceConflictException("Wrong namespace URI " + string2 + " for the xml prefix");
        }
        this.URI = string2;
    }

    public void setNamespacePrefix(String string2) {
        this._setNamespacePrefix(string2);
    }

    private void _setNamespacePrefix(String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() != 0) {
            Verifier.checkNCName(string2);
        }
        if ((string3 = this.getLocalNamespaceURI(string2)) != null) {
            if (!string3.equals(this.URI) && !"xml".equals(string2)) {
                throw new NamespaceConflictException(string2 + " conflicts with existing prefix");
            }
        } else if ("".equals(this.URI) && !"".equals(string2)) {
            throw new NamespaceConflictException("Cannot assign prefix to element in no namespace");
        }
        this.prefix = string2;
    }

    void insertionAllowed(Node node, int n) {
        if (node == null) {
            throw new NullPointerException("Tried to insert a null child in the tree");
        }
        if (node.getParent() != null) {
            throw new MultipleParentException(node.toString() + " child already has a parent.");
        }
        if (node.isElement()) {
            Element.checkCycle(node, this);
            return;
        }
        if (node.isText() || node.isProcessingInstruction() || node.isComment()) {
            return;
        }
        throw new IllegalAddException("Cannot add a " + node.getClass().getName() + " to an Element.");
    }

    private static void checkCycle(Node node, ParentNode parentNode) {
        if (node == parentNode) {
            throw new CycleException("Cannot add a node to itself");
        }
        if (node.getChildCount() == 0) {
            return;
        }
        while ((parentNode = parentNode.getParent()) != null) {
            if (parentNode != node) continue;
            throw new CycleException("Cannot add an ancestor as a child");
        }
    }

    public void insertChild(String string2, int n) {
        if (string2 == null) {
            throw new NullPointerException("Inserted null string");
        }
        super.fastInsertChild(new Text(string2), n);
    }

    public void appendChild(String string2) {
        this.insertChild(new Text(string2), this.getChildCount());
    }

    public Nodes removeChildren() {
        int n = this.getChildCount();
        Nodes nodes = new Nodes();
        for (int i = 0; i < n; ++i) {
            Node node = this.getChild(i);
            if (node.isElement()) {
                this.fillInBaseURI((Element)node);
            }
            node.setParent(null);
            nodes.append(node);
        }
        this.children = null;
        this.childCount = 0;
        return nodes;
    }

    public void addNamespaceDeclaration(String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string2.equals("xmlns")) {
            if (string3.equals("")) {
                return;
            }
            throw new NamespaceConflictException("The xmlns prefix cannot bound to any URI");
        }
        if (string2.equals("xml")) {
            if (string3.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + string3);
        }
        if (string3.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceConflictException("Wrong prefix for http://www.w3.org/XML/1998/namespace namespace: " + string2);
        }
        if (string2.length() != 0) {
            Verifier.checkNCName(string2);
            Verifier.checkAbsoluteURIReference(string3);
        } else if (string3.length() != 0) {
            Verifier.checkAbsoluteURIReference(string3);
        }
        String string4 = this.getLocalNamespaceURI(string2);
        if (string4 != null && !string4.equals(string3)) {
            String string5 = string2.equals("") ? "Additional namespace " + string3 + " conflicts with existing default namespace " + string4 : "Additional namespace " + string3 + " for the prefix " + string2 + " conflicts with existing namespace binding " + string4;
            throw new NamespaceConflictException(string5);
        }
        if (this.namespaces == null) {
            this.namespaces = new Namespaces();
        }
        this.namespaces.put(string2, string3);
    }

    public void removeNamespaceDeclaration(String string2) {
        if (this.namespaces != null) {
            this.namespaces.remove(string2);
        }
    }

    public final int getNamespaceDeclarationCount() {
        HashSet<String> hashSet = null;
        if (this.namespaces != null) {
            hashSet = new HashSet<String>(this.namespaces.getPrefixes());
            hashSet.add(this.prefix);
        }
        if ("xml".equals(this.prefix)) {
            hashSet = new HashSet();
        }
        int n = this.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = this.attributes[i];
            String string2 = attribute.getNamespacePrefix();
            if (string2.length() == 0 || "xml".equals(string2)) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
                hashSet.add(this.prefix);
            }
            hashSet.add(string2);
        }
        if (hashSet == null) {
            return 1;
        }
        return hashSet.size();
    }

    Map getNamespacePrefixesInScope() {
        HashMap hashMap = new HashMap();
        Element element = this;
        while (true) {
            ParentNode parentNode;
            Object object;
            int n;
            int n2;
            if (!"xml".equals(element.prefix)) {
                this.addPrefixIfNotAlreadyPresent(hashMap, element, element.prefix);
            }
            if (element.attributes != null) {
                n2 = element.numAttributes;
                for (n = 0; n < n2; ++n) {
                    object = element.attributes[n];
                    String string2 = ((Attribute)object).getNamespacePrefix();
                    if (string2.length() == 0 || "xml".equals(string2)) continue;
                    this.addPrefixIfNotAlreadyPresent(hashMap, element, string2);
                }
            }
            if (element.namespaces != null) {
                n2 = element.namespaces.size();
                for (n = 0; n < n2; ++n) {
                    object = element.namespaces.getPrefix(n);
                    this.addPrefixIfNotAlreadyPresent(hashMap, element, (String)object);
                }
            }
            if ((parentNode = element.getParent()) == null || parentNode.isDocument() || parentNode.isDocumentFragment()) break;
            element = (Element)parentNode;
        }
        return hashMap;
    }

    private void addPrefixIfNotAlreadyPresent(HashMap hashMap, Element element, String string2) {
        if (!hashMap.containsKey(string2)) {
            hashMap.put(string2, element.getLocalNamespaceURI(string2));
        }
    }

    public final String getNamespacePrefix(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative prefix number " + n);
        }
        if (n == 0 && !"xml".equals(this.prefix)) {
            return this.prefix;
        }
        Set set = this.getNamespacePrefixes();
        Iterator iterator2 = set.iterator();
        try {
            for (int i = 0; i < n; ++i) {
                iterator2.next();
            }
            return (String)iterator2.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("No " + n + "th namespace");
        }
    }

    private Set getNamespacePrefixes() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (!"xml".equals(this.prefix)) {
            linkedHashSet.add(this.prefix);
        }
        if (this.namespaces != null) {
            linkedHashSet.addAll(this.namespaces.getPrefixes());
        }
        if (this.attributes != null) {
            int n = this.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                Attribute attribute = this.attributes[i];
                String string2 = attribute.getNamespacePrefix();
                if (string2.length() == 0 || "xml".equals(string2)) continue;
                linkedHashSet.add(string2);
            }
        }
        return linkedHashSet;
    }

    public void setBaseURI(String string2) {
        this.setActualBaseURI(string2);
    }

    public String getBaseURI() {
        String string2;
        block7: {
            String string3;
            string2 = "";
            String string4 = this.getActualBaseURI();
            ParentNode parentNode = this;
            do {
                string3 = parentNode.getActualBaseURI();
                if (string4.length() != 0 && !string4.equals(string3)) {
                    string2 = URIUtil.absolutize(string4, string2);
                    break block7;
                }
                if (parentNode.isDocument()) {
                    string2 = URIUtil.absolutize(string3, string2);
                    break block7;
                }
                Attribute attribute = parentNode.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
                if (attribute == null) continue;
                String string5 = attribute.getValue();
                String string6 = URIUtil.toURI(string5);
                if ("".equals(string6)) {
                    string2 = this.getEntityURI();
                    break block7;
                }
                if (!this.legalURI(string6)) continue;
                if ("".equals(string2)) {
                    string2 = string6;
                } else {
                    if (URIUtil.isOpaque(string6)) break block7;
                    string2 = URIUtil.absolutize(string6, string2);
                }
                if (URIUtil.isAbsolute(string6)) break block7;
            } while ((parentNode = parentNode.getParent()) != null);
            string2 = URIUtil.absolutize(string3, string2);
        }
        if (URIUtil.isAbsolute(string2)) {
            return string2;
        }
        return "";
    }

    private String getEntityURI() {
        for (ParentNode parentNode = this; parentNode != null; parentNode = parentNode.getParent()) {
            if (parentNode.actualBaseURI == null || parentNode.actualBaseURI.length() == 0) continue;
            return parentNode.actualBaseURI;
        }
        return "";
    }

    private boolean legalURI(String string2) {
        try {
            Verifier.checkURIReference(string2);
            return true;
        }
        catch (MalformedURIException malformedURIException) {
            return false;
        }
    }

    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Node node = this;
        boolean bl = false;
        int n = -1;
        int[] nArray = new int[10];
        int n2 = 0;
        nArray[0] = -1;
        while (true) {
            if (!bl && node.getChildCount() > 0) {
                Element.writeStartTag((Element)node, stringBuffer);
                node = node.getChild(0);
                n = 0;
                nArray = Element.grow(nArray, ++n2);
                nArray[n2] = 0;
                continue;
            }
            if (bl) {
                Element.writeEndTag((Element)node, stringBuffer);
                if (node == this) {
                    break;
                }
            } else if (node.isElement()) {
                Element.writeStartTag((Element)node, stringBuffer);
                if (node == this) {
                    break;
                }
            } else {
                stringBuffer.append(node.toXML());
            }
            bl = false;
            ParentNode parentNode = node.getParent();
            if (parentNode.getChildCount() - 1 == n) {
                node = parentNode;
                --n2;
                if (node != this) {
                    n = nArray[n2];
                }
                bl = true;
                continue;
            }
            nArray[n2] = ++n;
            node = parentNode.getChild(n);
        }
        return stringBuffer.toString();
    }

    private static void writeStartTag(Element element, StringBuffer stringBuffer) {
        Object object;
        int n;
        stringBuffer.append('<');
        stringBuffer.append(element.getQualifiedName());
        ParentNode parentNode = element.getParent();
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            Element element2;
            object = element.getNamespacePrefix(n);
            String string2 = element.getNamespaceURI((String)object);
            if (parentNode != null && parentNode.isElement() ? string2.equals((element2 = (Element)parentNode).getNamespaceURI((String)object)) : string2.length() == 0) continue;
            stringBuffer.append(" xmlns");
            if (((String)object).length() > 0) {
                stringBuffer.append(':');
                stringBuffer.append((String)object);
            }
            stringBuffer.append("=\"");
            stringBuffer.append(Element.escape(string2));
            stringBuffer.append('\"');
        }
        if (element.attributes != null) {
            for (n = 0; n < element.numAttributes; ++n) {
                object = element.attributes[n];
                stringBuffer.append(' ');
                stringBuffer.append(((Attribute)object).toXML());
            }
        }
        if (element.getChildCount() > 0) {
            stringBuffer.append('>');
        } else {
            stringBuffer.append(" />");
        }
    }

    private static String escape(String string2) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n + 12);
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void writeEndTag(Element element, StringBuffer stringBuffer) {
        stringBuffer.append("</");
        stringBuffer.append(element.getQualifiedName());
        stringBuffer.append('>');
    }

    public final String getValue() {
        int n = this.getChildCount();
        if (n == 0) {
            return "";
        }
        Node node = this.getChild(0);
        if (n == 1 && node.isText()) {
            return node.getValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int[] nArray = new int[10];
        int n3 = 0;
        nArray[0] = 0;
        boolean bl = false;
        while (true) {
            ParentNode parentNode;
            if (!bl && node.getChildCount() > 0) {
                node = node.getChild(0);
                n2 = 0;
                nArray = Element.grow(nArray, ++n3);
                nArray[n3] = 0;
                continue;
            }
            bl = false;
            if (node.isText()) {
                stringBuffer.append(node.getValue());
            }
            if ((parentNode = node.getParent()).getChildCount() - 1 == n2) {
                node = parentNode;
                --n3;
                if (node == this) break;
                n2 = nArray[n3];
                bl = true;
                continue;
            }
            nArray[n3] = ++n2;
            node = parentNode.getChild(n2);
        }
        return stringBuffer.toString();
    }

    public Node copy() {
        Element element = Element.copyTag(this);
        Element.copyChildren(this, element);
        return element;
    }

    protected Element shallowCopy() {
        return new Element(this.getQualifiedName(), this.getNamespaceURI());
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "]";
    }

    boolean isElement() {
        return true;
    }

    private void checkPrefixConflict(Attribute attribute) {
        String string2 = attribute.getNamespacePrefix();
        String string3 = attribute.getNamespaceURI();
        for (int i = 0; i < this.numAttributes; ++i) {
            Attribute attribute2 = this.attributes[i];
            if (!attribute2.getNamespacePrefix().equals(string2)) continue;
            if (attribute2.getNamespaceURI().equals(string3)) {
                return;
            }
            throw new NamespaceConflictException("Prefix of " + attribute.getQualifiedName() + " conflicts with " + attribute2.getQualifiedName());
        }
    }

    Iterator attributeIterator() {
        return new Iterator(){
            private int next = 0;

            public boolean hasNext() {
                return this.next < Element.this.numAttributes;
            }

            public Object next() throws NoSuchElementException {
                if (this.hasNext()) {
                    Attribute attribute = Element.this.attributes[this.next];
                    ++this.next;
                    return attribute;
                }
                throw new NoSuchElementException("No such attribute");
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

