/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.IllegalDataException;
import nu.xom.Node;
import nu.xom.Text;
import nu.xom.Verifier;

public class Comment
extends Node {
    private String data;

    public Comment(String string2) {
        this._setValue(string2);
    }

    public Comment(Comment comment2) {
        this.data = comment2.data;
    }

    private Comment() {
    }

    static Comment build(String string2) {
        Comment comment2 = new Comment();
        comment2.data = string2;
        return comment2;
    }

    public final String getValue() {
        return this.data;
    }

    public void setValue(String string2) {
        this._setValue(string2);
    }

    private void _setValue(String string2) {
        if (string2 == null) {
            string2 = "";
        } else {
            Verifier.checkPCDATA(string2);
            if (string2.indexOf("--") != -1) {
                IllegalDataException illegalDataException = new IllegalDataException("Comment data contains a double hyphen (--).");
                illegalDataException.setData(string2);
                throw illegalDataException;
            }
            if (string2.indexOf(13) != -1) {
                IllegalDataException illegalDataException = new IllegalDataException("Comment data cannot contain carriage returns.");
                illegalDataException.setData(string2);
                throw illegalDataException;
            }
            if (string2.endsWith("-")) {
                IllegalDataException illegalDataException = new IllegalDataException("Comment data ends with a hyphen.");
                illegalDataException.setData(string2);
                throw illegalDataException;
            }
        }
        this.data = string2;
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Comment(this.data);
    }

    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer("<!--");
        stringBuffer.append(this.data);
        stringBuffer.append("-->");
        return stringBuffer.toString();
    }

    public final String toString() {
        String string2 = this.getValue();
        if (string2.length() <= 40) {
            return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(string2) + "]";
        }
        return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(string2.substring(0, 35)) + "...]";
    }

    boolean isComment() {
        return true;
    }
}

