/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.IllegalDataException;
import nu.xom.IllegalNameException;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.Verifier;

public class Attribute
extends Node {
    private String localName;
    private String prefix;
    private String URI;
    private String value = "";
    private Type type;

    public Attribute(String string2, String string3) {
        this(string2, "", string3, Type.UNDECLARED);
    }

    public Attribute(String string2, String string3, Type type) {
        this(string2, "", string3, type);
    }

    public Attribute(String string2, String string3, String string4) {
        this(string2, string3, string4, Type.UNDECLARED);
    }

    public Attribute(String string2, String string3, String string4, Type type) {
        this.prefix = "";
        String string5 = string2;
        int n = string2.indexOf(58);
        if (n > 0) {
            this.prefix = string2.substring(0, n);
            string5 = string2.substring(n + 1);
        }
        try {
            this._setLocalName(string5);
        }
        catch (IllegalNameException illegalNameException) {
            illegalNameException.setData(string2);
            throw illegalNameException;
        }
        this._setNamespace(this.prefix, string3);
        this._setValue(string4);
        if (this.isXMLID()) {
            this._setType(Type.ID);
        } else {
            this._setType(type);
        }
    }

    public Attribute(Attribute attribute) {
        this.localName = attribute.localName;
        this.prefix = attribute.prefix;
        this.URI = attribute.URI;
        this.value = attribute.value;
        this.type = attribute.type;
    }

    private Attribute() {
    }

    static Attribute build(String string2, String string3, String string4, Type type, String string5) {
        Attribute attribute = new Attribute();
        String string6 = "";
        int n = string2.indexOf(58);
        if (n >= 0) {
            string6 = string2.substring(0, n);
            if ("xml:id".equals(string2)) {
                type = Type.ID;
                string4 = Attribute.normalize(string4);
            }
        }
        attribute.localName = string5;
        attribute.prefix = string6;
        attribute.type = type;
        attribute.URI = string3;
        attribute.value = string4;
        return attribute;
    }

    private static String normalize(String string2) {
        int n;
        int n2;
        int n3 = string2.length();
        for (n2 = 0; n2 < n3 && string2.charAt(n2) == ' '; ++n2) {
        }
        string2 = string2.substring(n2);
        for (n = string2.length() - 1; n > 0 && string2.charAt(n) == ' '; --n) {
        }
        string2 = string2.substring(0, n + 1);
        n3 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n3);
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            char c = string2.charAt(i);
            if (c == ' ') {
                if (bl) continue;
                stringBuffer.append(' ');
                bl = true;
                continue;
            }
            stringBuffer.append(c);
            bl = false;
        }
        return stringBuffer.toString();
    }

    public final Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException("Null attribute type");
        }
        if (this.isXMLID() && !Type.ID.equals(type)) {
            throw new IllegalDataException("Can't change type of xml:id attribute to " + type);
        }
        this._setType(type);
    }

    private boolean isXMLID() {
        return "xml".equals(this.prefix) && "id".equals(this.localName);
    }

    private void _setType(Type type) {
        this.type = type;
    }

    public final String getValue() {
        return this.value;
    }

    public void setValue(String string2) {
        this._setValue(string2);
    }

    private void _setValue(String string2) {
        Verifier.checkPCDATA(string2);
        if (this.isXMLID()) {
            string2 = Attribute.normalize(string2);
        }
        this.value = string2;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String string2) {
        if ("id".equals(string2) && "http://www.w3.org/XML/1998/namespace".equals(this.URI)) {
            Verifier.checkNCName(this.value);
        }
        this._setLocalName(string2);
        if (this.isXMLID()) {
            this.setType(Type.ID);
        }
    }

    private void _setLocalName(String string2) {
        Verifier.checkNCName(string2);
        if (string2.equals("xmlns")) {
            throw new IllegalNameException("The Attribute class is not used for namespace declaration attributes.");
        }
        this.localName = string2;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public void setNamespace(String string2, String string3) {
        this._setNamespace(string2, string3);
        if (this.isXMLID()) {
            this.setType(Type.ID);
        }
    }

    private void _setNamespace(String string2, String string3) {
        Element element;
        String string4;
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string2.equals("xmlns")) {
            throw new IllegalNameException("Attribute objects are not used to represent  namespace declarations");
        }
        if (string2.equals("xml") && !string3.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + string3);
        }
        if (string3.equals("http://www.w3.org/XML/1998/namespace") && !string2.equals("xml")) {
            throw new NamespaceConflictException("Wrong prefix for the XML namespace: " + string2);
        }
        if (string2.length() == 0) {
            if (string3.length() == 0) {
                this.prefix = "";
                this.URI = "";
                return;
            }
            throw new NamespaceConflictException("Unprefixed attribute " + this.localName + " cannot be in default namespace " + string3);
        }
        if (string3.length() == 0) {
            throw new NamespaceConflictException("Attribute prefixes must be declared.");
        }
        ParentNode parentNode = this.getParent();
        if (parentNode != null && (string4 = (element = (Element)parentNode).getLocalNamespaceURI(string2)) != null && !string4.equals(string3)) {
            throw new NamespaceConflictException("New prefix " + string2 + "conflicts with existing namespace declaration");
        }
        Verifier.checkAbsoluteURIReference(string3);
        Verifier.checkNCName(string2);
        this.URI = string3;
        this.prefix = string2;
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("Attributes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Attribute(this);
    }

    public final String toXML() {
        return this.getQualifiedName() + "=\"" + Attribute.escapeText(this.value) + "\"";
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "=\"" + Text.escapeLineBreaksAndTruncate(this.getValue()) + "\"]";
    }

    private static String escapeText(String string2) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n + 12);
        block56: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuffer.append("&#x09;");
                    continue block56;
                }
                case '\n': {
                    stringBuffer.append("&#x0A;");
                    continue block56;
                }
                case '\u000b': {
                    continue block56;
                }
                case '\f': {
                    continue block56;
                }
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block56;
                }
                case '\u000e': {
                    continue block56;
                }
                case '\u000f': {
                    continue block56;
                }
                case '\u0010': {
                    continue block56;
                }
                case '\u0011': {
                    continue block56;
                }
                case '\u0012': {
                    continue block56;
                }
                case '\u0013': {
                    continue block56;
                }
                case '\u0014': {
                    continue block56;
                }
                case '\u0015': {
                    continue block56;
                }
                case '\u0016': {
                    continue block56;
                }
                case '\u0017': {
                    continue block56;
                }
                case '\u0018': {
                    continue block56;
                }
                case '\u0019': {
                    continue block56;
                }
                case '\u001a': {
                    continue block56;
                }
                case '\u001b': {
                    continue block56;
                }
                case '\u001c': {
                    continue block56;
                }
                case '\u001d': {
                    continue block56;
                }
                case '\u001e': {
                    continue block56;
                }
                case '\u001f': {
                    continue block56;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    continue block56;
                }
                case '!': {
                    stringBuffer.append('!');
                    continue block56;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block56;
                }
                case '#': {
                    stringBuffer.append('#');
                    continue block56;
                }
                case '$': {
                    stringBuffer.append('$');
                    continue block56;
                }
                case '%': {
                    stringBuffer.append('%');
                    continue block56;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block56;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    continue block56;
                }
                case '(': {
                    stringBuffer.append('(');
                    continue block56;
                }
                case ')': {
                    stringBuffer.append(')');
                    continue block56;
                }
                case '*': {
                    stringBuffer.append('*');
                    continue block56;
                }
                case '+': {
                    stringBuffer.append('+');
                    continue block56;
                }
                case ',': {
                    stringBuffer.append(',');
                    continue block56;
                }
                case '-': {
                    stringBuffer.append('-');
                    continue block56;
                }
                case '.': {
                    stringBuffer.append('.');
                    continue block56;
                }
                case '/': {
                    stringBuffer.append('/');
                    continue block56;
                }
                case '0': {
                    stringBuffer.append('0');
                    continue block56;
                }
                case '1': {
                    stringBuffer.append('1');
                    continue block56;
                }
                case '2': {
                    stringBuffer.append('2');
                    continue block56;
                }
                case '3': {
                    stringBuffer.append('3');
                    continue block56;
                }
                case '4': {
                    stringBuffer.append('4');
                    continue block56;
                }
                case '5': {
                    stringBuffer.append('5');
                    continue block56;
                }
                case '6': {
                    stringBuffer.append('6');
                    continue block56;
                }
                case '7': {
                    stringBuffer.append('7');
                    continue block56;
                }
                case '8': {
                    stringBuffer.append('8');
                    continue block56;
                }
                case '9': {
                    stringBuffer.append('9');
                    continue block56;
                }
                case ':': {
                    stringBuffer.append(':');
                    continue block56;
                }
                case ';': {
                    stringBuffer.append(';');
                    continue block56;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block56;
                }
                case '=': {
                    stringBuffer.append('=');
                    continue block56;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block56;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    boolean isAttribute() {
        return true;
    }

    public static final class Type {
        public static final Type CDATA = new Type(1);
        public static final Type ID = new Type(2);
        public static final Type IDREF = new Type(3);
        public static final Type IDREFS = new Type(4);
        public static final Type NMTOKEN = new Type(5);
        public static final Type NMTOKENS = new Type(6);
        public static final Type NOTATION = new Type(7);
        public static final Type ENTITY = new Type(8);
        public static final Type ENTITIES = new Type(9);
        public static final Type ENUMERATION = new Type(10);
        public static final Type UNDECLARED = new Type(0);
        private final int type;

        public String getName() {
            switch (this.type) {
                case 0: {
                    return "UNDECLARED";
                }
                case 1: {
                    return "CDATA";
                }
                case 2: {
                    return "ID";
                }
                case 3: {
                    return "IDREF";
                }
                case 4: {
                    return "IDREFS";
                }
                case 5: {
                    return "NMTOKEN";
                }
                case 6: {
                    return "NMTOKENS";
                }
                case 7: {
                    return "NOTATION";
                }
                case 8: {
                    return "ENTITY";
                }
                case 9: {
                    return "ENTITIES";
                }
                case 10: {
                    return "ENUMERATION";
                }
            }
            throw new RuntimeException("Bug in XOM: unexpected attribute type: " + this.type);
        }

        private Type(int n) {
            this.type = n;
        }

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.hashCode() != object.hashCode()) {
                return false;
            }
            return object.getClass().getName().equals("nu.xom.Attribute.Type");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[Attribute.Type: ");
            stringBuffer.append(this.getName());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

