/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class IR
extends AbstractIterativeSolver {
    private Vector z;
    private Vector r;

    public IR(Vector template) {
        this.z = template.copy();
        this.r = template.copy();
    }

    @Override
    public Vector solve(Matrix A, Vector b, Vector x2) throws IterativeSolverNotConvergedException {
        this.checkSizes(A, b, x2);
        A.multAdd(-1.0, x2, this.r.set(b));
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x2)) {
            this.M.apply(this.r, this.z);
            x2.add(this.z);
            A.multAdd(-1.0, x2, this.r.set(b));
            this.iter.next();
        }
        return x2;
    }
}

