/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.UpperCompRowMatrix;

public class ICC
implements Preconditioner {
    private final CompRowMatrix R;
    private Matrix Rt;
    private final Vector y;

    public ICC(CompRowMatrix R) {
        if (!R.isSquare()) {
            throw new IllegalArgumentException("ICC only applies to square matrices");
        }
        this.R = R;
        int n = R.numRows();
        this.y = new DenseVector(n);
    }

    @Override
    public Vector apply(Vector b, Vector x2) {
        this.Rt.transSolve(b, this.y);
        return this.Rt.solve(this.y, x2);
    }

    @Override
    public Vector transApply(Vector b, Vector x2) {
        return this.apply(b, x2);
    }

    @Override
    public void setMatrix(Matrix A) {
        this.R.set(A);
        this.factor();
    }

    private void factor() {
        int n = this.R.numRows();
        int[] colind = this.R.getColumnIndices();
        int[] rowptr = this.R.getRowPointers();
        double[] data2 = this.R.getData();
        double[] Rk = new double[n];
        int[] diagind = this.findDiagonalIndices(n, colind, rowptr);
        for (int k = 0; k < n; ++k) {
            int i;
            java.util.Arrays.fill(Rk, 0.0);
            for (i = rowptr[k]; i < rowptr[k + 1]; ++i) {
                Rk[colind[i]] = data2[i];
            }
            for (i = 0; i < k; ++i) {
                double Rii = data2[diagind[i]];
                if (Rii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ICC process");
                }
                double Rki = Rk[i] / Rii;
                if (Rki == 0.0) continue;
                for (int j = diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                    int n2 = colind[j];
                    Rk[n2] = Rk[n2] - Rki * data2[j];
                }
            }
            if (Rk[k] == 0.0) {
                throw new RuntimeException("Zero diagonal entry encountered on row " + (k + 1) + " during ICC process");
            }
            double sqRkk = Math.sqrt(Rk[k]);
            for (int i2 = diagind[k]; i2 < rowptr[k + 1]; ++i2) {
                data2[i2] = Rk[colind[i2]] / sqRkk;
            }
        }
        this.Rt = new UpperCompRowMatrix(this.R, diagind);
    }

    private int[] findDiagonalIndices(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        for (int k = 0; k < m; ++k) {
            diagind[k] = Arrays.binarySearch(colind, k, rowptr[k], rowptr[k + 1]);
            if (diagind[k] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
        }
        return diagind;
    }
}

