/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompColMatrix;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.SSOR;

public class AMG
implements Preconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private CompRowMatrix[] A;
    private DenseLU lu;
    private DenseVector[] u;
    private DenseVector[] f;
    private DenseVector[] r;
    private CompColMatrix[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final double omegaPreF;
    private final double omegaPreR;
    private final double omegaPostF;
    private final double omegaPostR;
    private final boolean reverse;
    private final double omega;
    private boolean transpose;

    public AMG(double omegaPreF, double omegaPreR, double omegaPostF, double omegaPostR, int nu1, int nu2, int gamma, int min2, double omega) {
        this.omegaPreF = omegaPreF;
        this.omegaPreR = omegaPreR;
        this.omegaPostF = omegaPostF;
        this.omegaPostR = omegaPostR;
        this.reverse = true;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min2;
        this.omega = omega;
    }

    public AMG(double omegaPre, double omegaPost, int nu1, int nu2, int gamma, int min2, double omega) {
        this.omegaPreF = omegaPre;
        this.omegaPreR = omegaPre;
        this.omegaPostF = omegaPost;
        this.omegaPostR = omegaPost;
        this.reverse = false;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min2;
        this.omega = omega;
    }

    public AMG() {
        this(1.0, 1.85, 1.85, 1.0, 1, 1, 1, 40, 0.6666666666666666);
    }

    @Override
    public Vector apply(Vector b, Vector x2) {
        this.u[0].set(x2);
        this.f[0].set(b);
        this.transpose = false;
        this.cycle(0);
        return x2.set(this.u[0]);
    }

    @Override
    public Vector transApply(Vector b, Vector x2) {
        this.u[0].set(x2);
        this.f[0].set(b);
        this.transpose = true;
        this.cycle(0);
        return x2.set(this.u[0]);
    }

    @Override
    public void setMatrix(Matrix A) {
        int k;
        double eps;
        CompRowMatrix Af;
        Aggregator aggregator;
        LinkedList<CompRowMatrix> Al = new LinkedList<CompRowMatrix>();
        LinkedList<CompColMatrix> Il = new LinkedList<CompColMatrix>();
        Al.add(new CompRowMatrix(A));
        int k2 = 0;
        while (((CompRowMatrix)Al.get(k2)).numRows() > this.min && (aggregator = new Aggregator(Af = (CompRowMatrix)Al.get(k2), eps = 0.08 * Math.pow(0.5, k2))).getAggregates().size() != 0) {
            Interpolator sa = new Interpolator(aggregator, Af, this.omega);
            Al.add(sa.getGalerkinOperator());
            Il.add(sa.getInterpolationOperator());
            ++k2;
        }
        this.m = Al.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new CompColMatrix[this.m - 1];
        this.A = new CompRowMatrix[this.m - 1];
        Il.toArray(this.I);
        for (int i = 0; i < Al.size() - 1; ++i) {
            this.A[i] = (CompRowMatrix)Al.get(i);
        }
        DenseMatrix Ac = new DenseMatrix((Matrix)Al.get(Al.size() - 1));
        this.lu = new DenseLU(Ac.numRows(), Ac.numColumns());
        this.lu.factor(Ac);
        this.u = new DenseVector[this.m];
        this.f = new DenseVector[this.m];
        this.r = new DenseVector[this.m];
        for (k = 0; k < this.m; ++k) {
            int n = ((CompRowMatrix)Al.get(k)).numRows();
            this.u[k] = new DenseVector(n);
            this.f[k] = new DenseVector(n);
            this.r[k] = new DenseVector(n);
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        for (k = 0; k < this.m - 1; ++k) {
            CompRowMatrix Ak = this.A[k];
            this.preM[k] = new SSOR(Ak, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[k] = new SSOR(Ak, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[k].setMatrix(Ak);
            this.postM[k].setMatrix(Ak);
        }
    }

    private void cycle(int k) {
        if (k == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(k);
            this.u[k + 1].zero();
            this.A[k].multAdd(-1.0, this.u[k], this.r[k].set(this.f[k]));
            this.I[k].transMult(this.r[k], this.f[k + 1]);
            for (int i = 0; i < this.gamma; ++i) {
                this.cycle(k + 1);
            }
            this.I[k].multAdd(this.u[k + 1], this.u[k]);
            this.postRelax(k);
        }
    }

    private void directSolve() {
        int k = this.m - 1;
        this.u[k].set(this.f[k]);
        DenseMatrix U = new DenseMatrix(this.u[k], false);
        if (this.transpose) {
            this.lu.transSolve(U);
        } else {
            this.lu.solve(U);
        }
    }

    private void preRelax(int k) {
        for (int i = 0; i < this.nu1; ++i) {
            if (this.transpose) {
                this.preM[k].transApply(this.f[k], this.u[k]);
                continue;
            }
            this.preM[k].apply(this.f[k], this.u[k]);
        }
    }

    private void postRelax(int k) {
        for (int i = 0; i < this.nu2; ++i) {
            if (this.transpose) {
                this.postM[k].transApply(this.f[k], this.u[k]);
                continue;
            }
            this.postM[k].apply(this.f[k], this.u[k]);
        }
    }

    private static class Interpolator {
        private CompRowMatrix Ac;
        private CompColMatrix I;

        public Interpolator(Aggregator aggregator, CompRowMatrix A, double omega) {
            List<Set<Integer>> C = aggregator.getAggregates();
            List<Set<Integer>> N = aggregator.getNodeNeighborhoods();
            int[] diagind = aggregator.getDiagonalIndices();
            int[] pt = this.createTentativeProlongation(C, A.numRows());
            if (omega != 0.0) {
                List<Map<Integer, Double>> P = this.createSmoothedProlongation(C, N, A, diagind, omega, pt);
                this.I = this.createInterpolationMatrix(P, A.numRows());
                this.Ac = this.createGalerkinSlow(this.I, A);
            } else {
                this.Ac = this.createGalerkinFast(A, pt, C.size());
                this.I = this.createInterpolationMatrix(pt, C.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> C, int n) {
            int[] pt = new int[n];
            java.util.Arrays.fill(pt, -1);
            for (int i = 0; i < C.size(); ++i) {
                for (int j : C.get(i)) {
                    pt[j] = i;
                }
            }
            return pt;
        }

        private CompRowMatrix createGalerkinFast(CompRowMatrix A, int[] pt, int c) {
            int n = pt.length;
            FlexCompRowMatrix Ac = new FlexCompRowMatrix(c, c);
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data2 = A.getData();
            for (int i = 0; i < n; ++i) {
                if (pt[i] == -1) continue;
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    if (pt[colind[j]] == -1) continue;
                    Ac.add(pt[i], pt[colind[j]], data2[j]);
                }
            }
            return new CompRowMatrix(Ac);
        }

        private CompColMatrix createInterpolationMatrix(List<Map<Integer, Double>> P, int n) {
            Map<Integer, Double> Pj;
            int j;
            int c = P.size();
            int[][] nz = new int[c][];
            for (j = 0; j < c; ++j) {
                Pj = P.get(j);
                nz[j] = new int[Pj.size()];
                int l = 0;
                for (int k : Pj.keySet()) {
                    nz[j][l++] = k;
                }
            }
            this.I = new CompColMatrix(n, c, nz);
            for (j = 0; j < c; ++j) {
                Pj = P.get(j);
                for (Map.Entry<Integer, Double> e : Pj.entrySet()) {
                    this.I.set(e.getKey(), j, e.getValue());
                }
            }
            return this.I;
        }

        private CompColMatrix createInterpolationMatrix(int[] pt, int c) {
            FlexCompColMatrix If2 = new FlexCompColMatrix(pt.length, c);
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i] == -1) continue;
                If2.set(i, pt[i], 1.0);
            }
            return new CompColMatrix(If2);
        }

        public CompColMatrix getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Double>> createSmoothedProlongation(List<Set<Integer>> C, List<Set<Integer>> N, CompRowMatrix A, int[] diagind, double omega, int[] pt) {
            int n = A.numRows();
            int c = C.size();
            ArrayList<Map<Integer, Double>> P = new ArrayList<Map<Integer, Double>>(c);
            for (int i = 0; i < c; ++i) {
                P.add(new HashMap());
            }
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data2 = A.getData();
            double[] dot = new double[c];
            for (int i = 0; i < n; ++i) {
                if (pt[i] == -1) continue;
                java.util.Arrays.fill(dot, 0.0);
                Set<Integer> Ni = N.get(i);
                double weakAij = 0.0;
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    if (pt[colind[j]] == -1) continue;
                    double aij = data2[j];
                    if (aij != 0.0 && !Ni.contains(colind[j])) {
                        weakAij += aij;
                        continue;
                    }
                    int n2 = pt[colind[j]];
                    dot[n2] = dot[n2] + aij;
                }
                int n3 = pt[i];
                dot[n3] = dot[n3] - weakAij;
                double scale = -omega / data2[diagind[i]];
                int j = 0;
                while (j < dot.length) {
                    int n4 = j++;
                    dot[n4] = dot[n4] * scale;
                }
                int n5 = pt[i];
                dot[n5] = dot[n5] + 1.0;
                for (j = 0; j < dot.length; ++j) {
                    if (dot[j] == 0.0) continue;
                    ((Map)P.get(j)).put(i, dot[j]);
                }
            }
            return P;
        }

        private CompRowMatrix createGalerkinSlow(CompColMatrix I, CompRowMatrix A) {
            int n = I.numRows();
            int c = I.numColumns();
            FlexCompRowMatrix Ac = new FlexCompRowMatrix(c, c);
            double[] aiCol = new double[n];
            double[] iCol = new double[n];
            DenseVector aiV = new DenseVector(aiCol, false);
            DenseVector iV = new DenseVector(iCol, false);
            double[] itaiCol = new double[c];
            DenseVector itaiV = new DenseVector(itaiCol, false);
            int[] colptr = I.getColumnPointers();
            int[] rowind = I.getRowIndices();
            double[] Idata = I.getData();
            for (int k = 0; k < c; ++k) {
                int i;
                iV.zero();
                for (i = colptr[k]; i < colptr[k + 1]; ++i) {
                    iCol[rowind[i]] = Idata[i];
                }
                A.mult(iV, aiV);
                I.transMult(aiV, itaiV);
                for (i = 0; i < c; ++i) {
                    if (itaiCol[i] == 0.0) continue;
                    Ac.set(i, k, itaiCol[i]);
                }
            }
            return new CompRowMatrix(Ac);
        }

        public CompRowMatrix getGalerkinOperator() {
            return this.Ac;
        }
    }

    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(CompRowMatrix A, double eps) {
            this.diagind = this.findDiagonalIndices(A);
            this.N = this.findNodeNeighborhood(A, this.diagind, eps);
            boolean[] R = this.createInitialR(A);
            this.C = this.createInitialAggregates(this.N, R);
            this.C = this.enlargeAggregates(this.C, this.N, R);
            this.C = this.createFinalAggregates(this.C, this.N, R);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalIndices() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalIndices(CompRowMatrix A) {
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            int[] diagind = new int[A.numRows()];
            for (int i = 0; i < A.numRows(); ++i) {
                diagind[i] = Arrays.binarySearch(colind, i, rowptr[i], rowptr[i + 1]);
                if (diagind[i] >= 0) continue;
                throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i + 1));
            }
            return diagind;
        }

        private List<Set<Integer>> findNodeNeighborhood(CompRowMatrix A, int[] diagind, double eps) {
            this.N = new ArrayList<Set<Integer>>(A.numRows());
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data2 = A.getData();
            for (int i = 0; i < A.numRows(); ++i) {
                HashSet<Integer> Ni = new HashSet<Integer>();
                double aii = data2[diagind[i]];
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    double aij = data2[j];
                    double ajj = data2[diagind[colind[j]]];
                    if (!(Math.abs(aij) >= eps * Math.sqrt(aii * ajj))) continue;
                    Ni.add(colind[j]);
                }
                this.N.add(Ni);
            }
            return this.N;
        }

        private boolean[] createInitialR(CompRowMatrix A) {
            boolean[] R = new boolean[A.numRows()];
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data2 = A.getData();
            for (int i = 0; i < A.numRows(); ++i) {
                boolean hasOffDiagonal = false;
                for (int j = rowptr[i]; j < rowptr[i + 1]; ++j) {
                    if (colind[j] == i || data2[j] == 0.0) continue;
                    hasOffDiagonal = true;
                    break;
                }
                R[i] = hasOffDiagonal;
            }
            return R;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> N, boolean[] R) {
            this.C = new ArrayList<Set<Integer>>();
            for (int i = 0; i < R.length; ++i) {
                if (!R[i]) continue;
                boolean free = true;
                for (int j : N.get(i)) {
                    free &= R[j];
                }
                if (!free) continue;
                this.C.add(new HashSet(N.get(i)));
                for (int j : N.get(i)) {
                    R[j] = false;
                }
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            ArrayList belong = new ArrayList(R.length);
            for (int i = 0; i < R.length; ++i) {
                belong.add(new ArrayList());
            }
            for (int k = 0; k < C.size(); ++k) {
                for (int j : C.get(k)) {
                    ((List)belong.get(j)).add(k);
                }
            }
            int[] intersect2 = new int[C.size()];
            for (int i = 0; i < R.length; ++i) {
                if (!R[i]) continue;
                java.util.Arrays.fill(intersect2, 0);
                int largest = 0;
                int maxValue = 0;
                for (int j : N.get(i)) {
                    Iterator i$ = ((List)belong.get(j)).iterator();
                    while (i$.hasNext()) {
                        int k;
                        int n = k = ((Integer)i$.next()).intValue();
                        intersect2[n] = intersect2[n] + 1;
                        if (intersect2[k] <= maxValue) continue;
                        largest = k;
                        maxValue = intersect2[largest];
                    }
                }
                if (maxValue <= 0) continue;
                R[i] = false;
                C.get(largest).add(i);
            }
            return C;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            for (int i = 0; i < R.length; ++i) {
                if (!R[i]) continue;
                HashSet<Integer> Cn = new HashSet<Integer>();
                for (int j : N.get(i)) {
                    if (!R[j]) continue;
                    R[j] = false;
                    Cn.add(j);
                }
                if (Cn.isEmpty()) continue;
                C.add(Cn);
            }
            return C;
        }
    }
}

