/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.io;

import no.uib.cipr.matrix.io.MatrixInfo;

public class MatrixSize {
    private int numRows;
    private int numColumns;
    private int numEntries;

    public MatrixSize(int numRows, int numColumns, MatrixInfo info) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        if (!info.isDense()) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
        if (info.isGeneral()) {
            this.numEntries = numRows * numColumns;
        } else if (info.isSymmetric() || info.isHermitian()) {
            this.numEntries = (numRows * numColumns - numRows) / 2 + numRows;
        } else if (info.isSkewSymmetric()) {
            this.numEntries = (numRows * numColumns - numRows) / 2;
        }
    }

    public MatrixSize(int numRows, int numColumns, int numEntries) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numEntries = numEntries;
        long maxR = numRows;
        long maxC = numColumns;
        long max2 = maxR * maxC;
        if ((long)numEntries > max2) {
            throw new IllegalArgumentException("numEntries > numRows*numColumns");
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numColumns() {
        return this.numColumns;
    }

    public int numEntries() {
        return this.numEntries;
    }

    public boolean isSquare() {
        return this.numRows == this.numColumns;
    }
}

