/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.util.Arrays;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.distributed.BlockDiagonalPreconditioner;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.DistColMatrix;
import no.uib.cipr.matrix.distributed.DistMatrix;
import no.uib.cipr.matrix.distributed.DistRowMatrix;
import no.uib.cipr.matrix.distributed.DistVector;
import no.uib.cipr.matrix.sparse.Preconditioner;

@Deprecated
public class TwoLevelPreconditioner
extends BlockDiagonalPreconditioner {
    private static final int root = 0;
    private final DistMatrix A;
    private final Communicator comm;
    private final int rank;
    private final int size;
    private final int[] indexToRank;
    private final DistVector z;
    private final DistVector r;
    private final DenseMatrix A0;
    private final DenseVector b0;
    private final DenseLU lu;
    private final double[] Ai;
    private final double[][] Ai0;
    private final boolean row;
    private final double[][] zi0;

    public TwoLevelPreconditioner(Preconditioner prec, DistRowMatrix A, DistVector z) {
        super(prec);
        this.A = A;
        this.z = z;
        this.r = z.copy();
        this.row = true;
        this.indexToRank = this.createIndexToRank(A.numColumns(), A.getColumnOwnerships());
        this.comm = A.getCommunicator();
        this.rank = this.comm.rank();
        this.size = this.comm.size();
        this.A0 = new DenseMatrix(this.size, this.size);
        this.b0 = new DenseVector(this.size);
        this.lu = new DenseLU(this.size, this.size);
        this.Ai = new double[this.size];
        if (this.rank == 0) {
            this.Ai0 = new double[this.size][this.size];
            this.zi0 = new double[this.size][1];
        } else {
            this.Ai0 = null;
            this.zi0 = null;
        }
    }

    public TwoLevelPreconditioner(Preconditioner prec, DistColMatrix A, DistVector z) {
        super(prec);
        this.A = A;
        this.z = z;
        this.r = z.copy();
        this.row = false;
        this.indexToRank = this.createIndexToRank(A.numColumns(), A.getColumnOwnerships());
        this.comm = A.getCommunicator();
        this.rank = this.comm.rank();
        this.size = this.comm.size();
        this.A0 = new DenseMatrix(this.size, this.size);
        this.b0 = new DenseVector(this.size);
        this.lu = new DenseLU(this.size, this.size);
        this.Ai = new double[this.size];
        if (this.rank == 0) {
            this.Ai0 = new double[this.size][this.size];
            this.zi0 = new double[this.size][1];
        } else {
            this.Ai0 = null;
            this.zi0 = null;
        }
    }

    private int[] createIndexToRank(int size2, int[] n) {
        int[] indexToRank = new int[size2];
        for (int i = 0; i < n.length - 1; ++i) {
            for (int j = n[i]; j < n[i + 1]; ++j) {
                indexToRank[j] = i;
            }
        }
        return indexToRank;
    }

    @Override
    public Vector apply(Vector b, Vector x2) {
        if (!(b instanceof DistVector) || !(x2 instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        boolean transpose2 = false;
        return this.apply(b, x2, transpose2);
    }

    @Override
    public Vector transApply(Vector b, Vector x2) {
        if (!(b instanceof DistVector) || !(x2 instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        boolean transpose2 = true;
        return this.apply(b, x2, transpose2);
    }

    private Vector apply(Vector b, Vector x2, boolean transpose2) {
        this.calculateCoarseResidual(b, x2, transpose2);
        if (this.rank == 0) {
            this.solveCoarseSystem(transpose2);
        }
        this.updateWithCoarseCorrection(x2);
        return this.applyBlockPreconditioner(b, x2, transpose2);
    }

    private void calculateCoarseResidual(Vector b, Vector x2, boolean transpose2) {
        if (transpose2) {
            this.A.transMultAdd(-1.0, x2, this.z.set(b));
        } else {
            this.A.multAdd(-1.0, x2, this.z.set(b));
        }
        double zi = 0.0;
        for (VectorEntry e : this.z.getLocal()) {
            zi += e.get();
        }
        double[] zij = new double[]{zi};
        this.comm.gather(zij, (Object[])this.zi0, 0);
    }

    private void solveCoarseSystem(boolean transpose2) {
        for (int i = 0; i < this.size; ++i) {
            this.b0.set(i, this.zi0[i][0]);
        }
        if (transpose2) {
            this.lu.transSolve(new DenseMatrix(this.b0, false));
        } else {
            this.lu.solve(new DenseMatrix(this.b0, false));
        }
        double[] data2 = this.b0.getData();
        for (int i = 0; i < this.size; ++i) {
            this.zi0[i][0] = data2[i];
        }
    }

    private void updateWithCoarseCorrection(Vector x2) {
        DistVector xd = (DistVector)x2;
        double[] zij = new double[1];
        this.comm.scatter((Object[])this.zi0, zij, 0);
        for (VectorEntry e : xd.getLocal()) {
            e.set(e.get() + zij[0]);
        }
    }

    private Vector applyBlockPreconditioner(Vector b, Vector x2, boolean transpose2) {
        if (transpose2) {
            this.A.transMultAdd(-1.0, x2, this.z.set(b));
        } else {
            this.A.multAdd(-1.0, x2, this.z.set(b));
        }
        this.r.set(b);
        if (transpose2) {
            super.transApply(this.z, this.r);
        } else {
            super.apply(this.z, this.r);
        }
        return x2.add(this.r);
    }

    @Override
    public void setMatrix(Matrix A) {
        if (!(A instanceof DistMatrix)) {
            throw new IllegalArgumentException("A is not a DistRowMatrix or a DistColMatrix");
        }
        Matrix Ad = this.A.getBlock();
        Matrix Ao = this.A.getOff();
        super.setMatrix(A);
        Arrays.fill(this.Ai, 0.0);
        for (MatrixEntry e : Ad) {
            int n = this.rank;
            this.Ai[n] = this.Ai[n] + e.get();
        }
        if (this.row) {
            for (MatrixEntry e : Ao) {
                int n = this.indexToRank[e.column()];
                this.Ai[n] = this.Ai[n] + e.get();
            }
            this.comm.gather(this.Ai, (Object[])this.Ai0, 0);
            if (this.rank == 0) {
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        this.A0.set(i, j, this.Ai0[i][j]);
                    }
                }
            }
        } else {
            for (MatrixEntry e : Ao) {
                int n = this.indexToRank[e.row()];
                this.Ai[n] = this.Ai[n] + e.get();
            }
            this.comm.gather(this.Ai, (Object[])this.Ai0, 0);
            if (this.rank == 0) {
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        this.A0.set(i, j, this.Ai0[j][i]);
                    }
                }
            }
        }
        if (this.rank == 0) {
            this.lu.factor(this.A0);
        }
    }
}

