/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import no.uib.cipr.matrix.distributed.Reduction;

@Deprecated
public class Reductions {
    private Reductions() {
    }

    public static Reduction sum() {
        return new Sum();
    }

    public static Reduction product() {
        return new Product();
    }

    public static Reduction max() {
        return new Max();
    }

    public static Reduction min() {
        return new Min();
    }

    public static Reduction and() {
        return new And();
    }

    public static Reduction or() {
        return new Or();
    }

    private static class Or
    extends BooleanReduction {
        private Or() {
        }

        @Override
        protected void initBoolean(boolean[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = false;
            }
        }

        @Override
        protected void opBoolean(boolean[] x2, boolean[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] | y[i];
            }
        }
    }

    private static class And
    extends BooleanReduction {
        private And() {
        }

        @Override
        protected void initBoolean(boolean[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = true;
            }
        }

        @Override
        protected void opBoolean(boolean[] x2, boolean[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] & y[i];
            }
        }
    }

    private static abstract class BooleanReduction
    extends Reduction {
        private BooleanReduction() {
        }

        @Override
        protected void initByte(byte[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void initChar(char[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void initShort(short[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void initInt(int[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void initFloat(float[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void initLong(long[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void initDouble(double[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opByte(byte[] x2, byte[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opChar(char[] x2, char[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opShort(short[] x2, short[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opInt(int[] x2, int[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opFloat(float[] x2, float[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opLong(long[] x2, long[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opDouble(double[] x2, double[] y) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class NumericalReduction
    extends Reduction {
        private NumericalReduction() {
        }

        @Override
        protected void initBoolean(boolean[] x2) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void opBoolean(boolean[] x2, boolean[] y) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Min
    extends NumericalReduction {
        private Min() {
        }

        @Override
        protected void initByte(byte[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 127;
            }
        }

        @Override
        protected void initChar(char[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 65535;
            }
        }

        @Override
        protected void initShort(short[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Short.MAX_VALUE;
            }
        }

        @Override
        protected void initInt(int[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Integer.MAX_VALUE;
            }
        }

        @Override
        protected void initFloat(float[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Float.MAX_VALUE;
            }
        }

        @Override
        protected void initLong(long[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Long.MAX_VALUE;
            }
        }

        @Override
        protected void initDouble(double[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Double.MAX_VALUE;
            }
        }

        @Override
        protected void opByte(byte[] x2, byte[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = (byte)Math.min(x2[i], y[i]);
            }
        }

        @Override
        protected void opChar(char[] x2, char[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = (char)Math.min(x2[i], y[i]);
            }
        }

        @Override
        protected void opShort(short[] x2, short[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = (short)Math.min(x2[i], y[i]);
            }
        }

        @Override
        protected void opInt(int[] x2, int[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.min(x2[i], y[i]);
            }
        }

        @Override
        protected void opFloat(float[] x2, float[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.min(x2[i], y[i]);
            }
        }

        @Override
        protected void opLong(long[] x2, long[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.min(x2[i], y[i]);
            }
        }

        @Override
        protected void opDouble(double[] x2, double[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.min(x2[i], y[i]);
            }
        }
    }

    private static class Max
    extends NumericalReduction {
        private Max() {
        }

        @Override
        protected void initByte(byte[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = -128;
            }
        }

        @Override
        protected void initChar(char[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = '\u0000';
            }
        }

        @Override
        protected void initShort(short[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Short.MIN_VALUE;
            }
        }

        @Override
        protected void initInt(int[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Integer.MIN_VALUE;
            }
        }

        @Override
        protected void initFloat(float[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Float.MIN_VALUE;
            }
        }

        @Override
        protected void initLong(long[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Long.MIN_VALUE;
            }
        }

        @Override
        protected void initDouble(double[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Double.MIN_VALUE;
            }
        }

        @Override
        protected void opByte(byte[] x2, byte[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = (byte)Math.max(x2[i], y[i]);
            }
        }

        @Override
        protected void opChar(char[] x2, char[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = (char)Math.max(x2[i], y[i]);
            }
        }

        @Override
        protected void opShort(short[] x2, short[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = (short)Math.max(x2[i], y[i]);
            }
        }

        @Override
        protected void opInt(int[] x2, int[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.max(x2[i], y[i]);
            }
        }

        @Override
        protected void opFloat(float[] x2, float[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.max(x2[i], y[i]);
            }
        }

        @Override
        protected void opLong(long[] x2, long[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.max(x2[i], y[i]);
            }
        }

        @Override
        protected void opDouble(double[] x2, double[] y) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = Math.max(x2[i], y[i]);
            }
        }
    }

    private static class Product
    extends NumericalReduction {
        private Product() {
        }

        @Override
        protected void initByte(byte[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 1;
            }
        }

        @Override
        protected void initChar(char[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = '\u0001';
            }
        }

        @Override
        protected void initShort(short[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 1;
            }
        }

        @Override
        protected void initInt(int[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 1;
            }
        }

        @Override
        protected void initFloat(float[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 1.0f;
            }
        }

        @Override
        protected void initLong(long[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 1L;
            }
        }

        @Override
        protected void initDouble(double[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 1.0;
            }
        }

        @Override
        protected void opByte(byte[] x2, byte[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = (byte)(x2[n] * y[i]);
            }
        }

        @Override
        protected void opChar(char[] x2, char[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = (char)(x2[n] * y[i]);
            }
        }

        @Override
        protected void opShort(short[] x2, short[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = (short)(x2[n] * y[i]);
            }
        }

        @Override
        protected void opInt(int[] x2, int[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] * y[i];
            }
        }

        @Override
        protected void opFloat(float[] x2, float[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] * y[i];
            }
        }

        @Override
        protected void opLong(long[] x2, long[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] * y[i];
            }
        }

        @Override
        protected void opDouble(double[] x2, double[] y) {
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] * y[i];
            }
        }
    }

    private static class Sum
    extends NumericalReduction {
        private Sum() {
        }

        @Override
        protected void initByte(byte[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 0;
            }
        }

        @Override
        protected void initChar(char[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = '\u0000';
            }
        }

        @Override
        protected void initShort(short[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 0;
            }
        }

        @Override
        protected void initInt(int[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 0;
            }
        }

        @Override
        protected void initFloat(float[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 0.0f;
            }
        }

        @Override
        protected void initLong(long[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 0L;
            }
        }

        @Override
        protected void initDouble(double[] x2) {
            for (int i = 0; i < x2.length; ++i) {
                x2[i] = 0.0;
            }
        }

        @Override
        protected void opByte(byte[] x2, byte[] y) {
            assert (x2.length == y.length);
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = (byte)(x2[n] + y[i]);
            }
        }

        @Override
        protected void opChar(char[] x2, char[] y) {
            assert (x2.length == y.length);
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = (char)(x2[n] + y[i]);
            }
        }

        @Override
        protected void opShort(short[] x2, short[] y) {
            assert (x2.length == y.length);
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = (short)(x2[n] + y[i]);
            }
        }

        @Override
        protected void opInt(int[] x2, int[] y) {
            assert (x2.length == y.length);
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] + y[i];
            }
        }

        @Override
        protected void opFloat(float[] x2, float[] y) {
            assert (x2.length == y.length);
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] + y[i];
            }
        }

        @Override
        protected void opLong(long[] x2, long[] y) {
            assert (x2.length == y.length);
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] + y[i];
            }
        }

        @Override
        protected void opDouble(double[] x2, double[] y) {
            assert (x2.length == y.length);
            for (int i = 0; i < x2.length; ++i) {
                int n = i;
                x2[n] = x2[n] + y[i];
            }
        }
    }
}

