/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

public class UnitUpperTriangDenseMatrix
extends UpperTriangDenseMatrix {
    public UnitUpperTriangDenseMatrix(int n) {
        super(n, Diag.Unit);
    }

    public UnitUpperTriangDenseMatrix(Matrix A) {
        this(A, true);
    }

    public UnitUpperTriangDenseMatrix(Matrix A, boolean deep) {
        super(A, deep, Diag.Unit);
    }

    @Override
    public void add(int row, int column, double value2) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.add(row, column, value2);
    }

    @Override
    public double get(int row, int column) {
        if (row == column) {
            return 1.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value2) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.set(row, column, value2);
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() >= e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    @Override
    public UnitUpperTriangDenseMatrix copy() {
        return new UnitUpperTriangDenseMatrix(this);
    }

    @Override
    public Matrix zero() {
        throw new UnsupportedOperationException();
    }
}

