/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class SymmTridiagMatrix
extends AbstractMatrix {
    double[] diag;
    double[] offDiag;
    int n;

    public SymmTridiagMatrix(double[] diag, double[] offDiag, int n) {
        super(n, n);
        this.n = n;
        if (n < 1) {
            throw new IllegalArgumentException("n must be >= 1");
        }
        if (diag.length < n) {
            throw new IllegalArgumentException("diag.length < n");
        }
        if (offDiag.length < n - 1) {
            throw new IllegalArgumentException("offDiag.length < n - 1");
        }
        this.diag = diag;
        this.offDiag = offDiag;
    }

    public SymmTridiagMatrix(double[] diag, double[] offDiag) {
        this(diag, offDiag, diag.length);
    }

    public SymmTridiagMatrix(int n) {
        super(n, n);
        if (n < 1) {
            throw new IllegalArgumentException("n must be >= 1");
        }
        this.n = this.numRows;
        this.diag = new double[n];
        this.offDiag = new double[n - 1];
    }

    public SymmTridiagMatrix(Matrix A) {
        this(A, true);
    }

    public SymmTridiagMatrix(Matrix A, boolean deep) {
        super(A);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Symmetric matrix must be square");
        }
        if (A.numRows() < 1) {
            throw new IllegalArgumentException("numRows must be >= 1");
        }
        this.n = this.numRows;
        if (deep) {
            this.diag = new double[this.n];
            this.offDiag = new double[Math.max(this.n - 1, 0)];
            for (MatrixEntry e : A) {
                if (e.row() != e.column() && e.row() != e.column() + 1) continue;
                this.set(e.row(), e.column(), e.get());
            }
        } else {
            SymmTridiagMatrix B = (SymmTridiagMatrix)A;
            this.diag = B.getDiagonal();
            this.offDiag = B.getOffDiagonal();
        }
    }

    public double[] getDiagonal() {
        return this.diag;
    }

    public double[] getOffDiagonal() {
        return this.offDiag;
    }

    @Override
    public void add(int row, int column, double value2) {
        this.check(row, column);
        if (row == column) {
            int n = row;
            this.diag[n] = this.diag[n] + value2;
        } else if (row == column + 1) {
            int n = column;
            this.offDiag[n] = this.offDiag[n] + value2;
        } else if (row != column - 1) {
            throw new IndexOutOfBoundsException("Insertion index outside of band");
        }
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        if (row == column) {
            return this.diag[row];
        }
        if (row == column + 1) {
            return this.offDiag[column];
        }
        if (row == column - 1) {
            return this.offDiag[row];
        }
        return 0.0;
    }

    @Override
    public void set(int row, int column, double value2) {
        this.check(row, column);
        if (row == column) {
            this.diag[row] = value2;
        } else if (row == column + 1) {
            this.offDiag[column] = value2;
        } else if (row != column - 1) {
            throw new IndexOutOfBoundsException("Insertion index outside of band");
        }
    }

    @Override
    public SymmTridiagMatrix copy() {
        return new SymmTridiagMatrix(this);
    }

    @Override
    public SymmTridiagMatrix zero() {
        Arrays.fill(this.diag, 0.0);
        Arrays.fill(this.offDiag, 0.0);
        return this;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X2) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dgtsv(this.numRows, X2.numColumns(), (double[])this.offDiag.clone(), (double[])this.diag.clone(), (double[])this.offDiag.clone(), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    @Override
    public Vector solve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.solve(B, X2);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X2) {
        return this.solve(B, X2);
    }

    @Override
    public Vector transSolve(Vector b, Vector x2) {
        return this.solve(b, x2);
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new SymmTridiagMatrixIterator();
    }

    private class SymmTridiagMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private double[] band;
        private int bandIndex;
        private int whichBand;

        private SymmTridiagMatrixIterator() {
            this.band = SymmTridiagMatrix.this.diag;
        }

        @Override
        public boolean hasNext() {
            return this.whichBand < 3;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (this.bandIndex < this.band.length - 1) {
                ++this.bandIndex;
            } else {
                this.bandIndex = 0;
                ++this.whichBand;
                this.band = SymmTridiagMatrix.this.offDiag;
                if (this.band.length == 0) {
                    this.whichBand = 3;
                }
            }
            this.row = this.whichBand == 1 ? this.bandIndex + 1 : this.bandIndex;
            this.column = this.whichBand == 2 ? this.bandIndex + 1 : this.bandIndex;
            return this.entry;
        }
    }
}

