/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangPackMatrix;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class LowerTriangPackMatrix
extends AbstractTriangPackMatrix {
    public LowerTriangPackMatrix(int n) {
        super(n, UpLo.Lower, Diag.NonUnit);
    }

    LowerTriangPackMatrix(int n, Diag diag) {
        super(n, UpLo.Lower, diag);
    }

    public LowerTriangPackMatrix(Matrix A) {
        this(A, true);
    }

    public LowerTriangPackMatrix(Matrix A, boolean deep) {
        super(A, deep, UpLo.Lower, Diag.NonUnit);
    }

    LowerTriangPackMatrix(Matrix A, boolean deep, Diag diag) {
        super(A, deep, UpLo.Lower, diag);
    }

    @Override
    public void add(int row, int column, double value2) {
        if (column > row) {
            throw new IllegalArgumentException("column > row");
        }
        int n = this.getIndex(row, column);
        this.data[n] = this.data[n] + value2;
    }

    @Override
    public void set(int row, int column, double value2) {
        if (column > row) {
            throw new IllegalArgumentException("column > row");
        }
        this.data[this.getIndex((int)row, (int)column)] = value2;
    }

    @Override
    public double get(int row, int column) {
        if (column > row) {
            return 0.0;
        }
        return this.data[this.getIndex(row, column)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + (2 * this.n - (column + 1)) * column / 2;
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() < e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    @Override
    public LowerTriangPackMatrix copy() {
        return new LowerTriangPackMatrix(this);
    }
}

