/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class LowerSymmDenseMatrix
extends AbstractSymmDenseMatrix {
    public LowerSymmDenseMatrix(int n) {
        super(n, UpLo.Lower);
    }

    public LowerSymmDenseMatrix(Matrix A) {
        this(A, true);
    }

    public LowerSymmDenseMatrix(Matrix A, boolean deep) {
        super(A, deep, UpLo.Lower);
    }

    @Override
    public void add(int row, int column, double value2) {
        if (column <= row) {
            super.add(row, column, value2);
        }
    }

    @Override
    public double get(int row, int column) {
        if (column > row) {
            return super.get(column, row);
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value2) {
        if (column <= row) {
            super.set(row, column, value2);
        }
    }

    @Override
    public LowerSymmDenseMatrix copy() {
        return new LowerSymmDenseMatrix(this);
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() < e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }
}

