/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.io.IOException;
import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DenseMatrix
extends AbstractDenseMatrix {
    public DenseMatrix(MatrixVectorReader r) throws IOException {
        block10: {
            int i;
            MatrixInfo info;
            block9: {
                super(0, 0);
                info = null;
                info = r.hasInfo() ? r.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                MatrixSize size2 = r.readMatrixSize(info);
                this.numRows = size2.numRows();
                this.numColumns = size2.numColumns();
                this.data = new double[this.numRows * this.numColumns];
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                if (info.isCoordinate()) {
                    int nz = size2.numEntries();
                    int[] row = new int[nz];
                    int[] column = new int[nz];
                    double[] entry = new double[nz];
                    r.readCoordinate(row, column, entry);
                    r.add(-1, row);
                    r.add(-1, column);
                    for (int i2 = 0; i2 < nz; ++i2) {
                        this.set(row[i2], column[i2], entry[i2]);
                    }
                } else {
                    r.readArray(this.data);
                }
                if (!info.isSymmetric()) break block9;
                for (i = 0; i < this.numRows; ++i) {
                    for (int j = 0; j < i; ++j) {
                        this.set(j, i, this.get(i, j));
                    }
                }
                break block10;
            }
            if (!info.isSkewSymmetric()) break block10;
            for (i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < i; ++j) {
                    this.set(j, i, -this.get(i, j));
                }
            }
        }
    }

    public DenseMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public DenseMatrix(Matrix A) {
        super(A);
    }

    public DenseMatrix(Matrix A, boolean deep) {
        super(A, deep);
    }

    public DenseMatrix(Vector x2, boolean deep) {
        super(x2.size(), 1);
        if (deep) {
            for (VectorEntry e : x2) {
                this.set(e.index(), 0, e.get());
            }
        } else {
            if (!(x2 instanceof DenseVector)) {
                throw new IllegalArgumentException("x must be a DenseVector");
            }
            this.data = ((DenseVector)x2).getData();
        }
    }

    public DenseMatrix(Vector x2) {
        this(x2, true);
    }

    public DenseMatrix(Vector[] x2) {
        super(x2[0].size(), x2.length);
        for (Vector v : x2) {
            if (v.size() == this.numRows) continue;
            throw new IllegalArgumentException("All vectors must be of the same size");
        }
        for (int j = 0; j < x2.length; ++j) {
            for (VectorEntry e : x2[j]) {
                this.set(e.index(), j, e.get());
            }
        }
    }

    public DenseMatrix(double[][] values2) {
        super(values2.length, values2[0].length);
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i].length != this.numColumns) {
                throw new IllegalArgumentException("Array cannot be jagged");
            }
            for (int j = 0; j < values2[i].length; ++j) {
                this.set(i, j, values2[i][j]);
            }
        }
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this);
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            this.set(e.row(), e.column(), e.get());
        }
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.multAdd(alpha, B, C);
        }
        this.checkMultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.NoTranspose.netlib(), Transpose.NoTranspose.netlib(), C.numRows(), C.numColumns(), this.numColumns, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transAmultAdd(alpha, B, C);
        }
        this.checkTransAmultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.Transpose.netlib(), Transpose.NoTranspose.netlib(), C.numRows(), C.numColumns(), this.numRows, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transBmultAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transBmultAdd(alpha, B, C);
        }
        this.checkTransBmultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.NoTranspose.netlib(), Transpose.Transpose.netlib(), C.numRows(), C.numColumns(), this.numColumns, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transABmultAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transABmultAdd(alpha, B, C);
        }
        this.checkTransABmultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.Transpose.netlib(), Transpose.Transpose.netlib(), C.numRows(), C.numColumns(), this.numRows, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix rank1(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank1(alpha, x2, y);
        }
        this.checkRank1(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dger(this.numRows, this.numColumns, alpha, xd, 1, yd, 1, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y);
        }
        this.checkMultAdd(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgemv(Transpose.NoTranspose.netlib(), this.numRows, this.numColumns, alpha, this.data, Math.max(this.numRows, 1), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x2, y);
        }
        this.checkTransMultAdd(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgemv(Transpose.Transpose.netlib(), this.numRows, this.numColumns, alpha, this.data, Math.max(this.numRows, 1), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X2) {
        if (this.numRows != B.numRows()) {
            throw new IllegalArgumentException("numRows != B.numRows() (" + this.numRows + " != " + B.numRows() + ")");
        }
        if (this.numColumns != X2.numRows()) {
            throw new IllegalArgumentException("numColumns != X.numRows() (" + this.numColumns + " != " + X2.numRows() + ")");
        }
        if (X2.numColumns() != B.numColumns()) {
            throw new IllegalArgumentException("X.numColumns() != B.numColumns() (" + X2.numColumns() + " != " + B.numColumns() + ")");
        }
        if (this.isSquare()) {
            return this.LUsolve(B, X2);
        }
        return this.QRsolve(B, X2, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.solve(B, X2);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X2) {
        if (this.numColumns != B.numRows()) {
            throw new IllegalArgumentException("numColumns != B.numRows() (" + this.numColumns + " != " + B.numRows() + ")");
        }
        if (this.numRows != X2.numRows()) {
            throw new IllegalArgumentException("numRows != X.numRows() (" + this.numRows + " != " + X2.numRows() + ")");
        }
        if (X2.numColumns() != B.numColumns()) {
            throw new IllegalArgumentException("X.numColumns() != B.numColumns() (" + X2.numColumns() + " != " + B.numColumns() + ")");
        }
        return this.QRsolve(B, X2, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.transSolve(B, X2);
        return x2;
    }

    Matrix LUsolve(Matrix B, Matrix X2) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        int[] piv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dgesv(this.numRows, B.numColumns(), (double[])this.data.clone(), Matrices.ld(this.numRows), piv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    Matrix QRsolve(Matrix B, Matrix X2, Transpose trans) {
        int nrhs = B.numColumns();
        DenseMatrix Xtmp = new DenseMatrix(Math.max(this.numRows, this.numColumns), nrhs);
        int M = trans == Transpose.NoTranspose ? this.numRows : this.numColumns;
        for (int j = 0; j < nrhs; ++j) {
            for (int i = 0; i < M; ++i) {
                Xtmp.set(i, j, B.get(i, j));
            }
        }
        double[] newData = (double[])this.data.clone();
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgels(trans.netlib(), this.numRows, this.numColumns, nrhs, newData, Matrices.ld(this.numRows), Xtmp.getData(), Matrices.ld(this.numRows, this.numColumns), work, -1, info);
        int lwork = -1;
        lwork = info.val != 0 ? Math.max(1, Math.min(this.numRows, this.numColumns) + Math.max(Math.min(this.numRows, this.numColumns), nrhs)) : Math.max((int)work[0], 1);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dgels(trans.netlib(), this.numRows, this.numColumns, nrhs, newData, Matrices.ld(this.numRows), Xtmp.getData(), Matrices.ld(this.numRows, this.numColumns), work, lwork, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        int N = trans == Transpose.NoTranspose ? this.numColumns : this.numRows;
        for (int j = 0; j < nrhs; ++j) {
            for (int i = 0; i < N; ++i) {
                X2.set(i, j, Xtmp.get(i, j));
            }
        }
        return X2;
    }
}

