/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class BandMatrix
extends AbstractBandMatrix {
    public BandMatrix(int n, int kl, int ku) {
        super(n, kl, ku);
    }

    public BandMatrix(Matrix A, int kl, int ku) {
        super(A, kl, ku);
    }

    public BandMatrix(Matrix A, int kl, int ku, boolean deep) {
        super(A, kl, ku, deep);
    }

    @Override
    public BandMatrix copy() {
        return new BandMatrix(this, this.kl, this.ku);
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y);
        }
        this.checkMultAdd(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgbmv(Transpose.NoTranspose.netlib(), this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x2, y);
        }
        this.checkTransMultAdd(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgbmv(Transpose.Transpose.netlib(), this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X2) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        BandMatrix Af = new BandMatrix(this, this.kl, this.ku + this.kl);
        int[] ipiv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dgbsv(this.numRows, this.kl, this.ku, X2.numColumns(), Af.getData(), Matrices.ld(2 * this.kl + this.ku + 1), ipiv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    @Override
    public Vector solve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.solve(B, X2);
        return x2;
    }

    @Override
    public Matrix transpose() {
        this.checkTranspose();
        if (this.kl != this.ku) {
            throw new IllegalArgumentException("kl != ku");
        }
        for (int j = 0; j < this.numColumns; ++j) {
            for (int i = j + 1; i < Math.min(j + this.kl + 1, this.numRows); ++i) {
                double value2 = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, value2);
            }
        }
        return this;
    }
}

