/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

abstract class AbstractTriangPackMatrix
extends AbstractPackMatrix {
    UpLo uplo;
    Diag diag;

    AbstractTriangPackMatrix(int n, UpLo uplo, Diag diag) {
        super(n);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangPackMatrix(Matrix A, UpLo uplo, Diag diag) {
        this(A, false, uplo, diag);
    }

    AbstractTriangPackMatrix(Matrix A, boolean deep, UpLo uplo, Diag diag) {
        super(A, deep);
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x2, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x2, y);
        }
        this.checkMultAdd(x2, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x2);
        BLAS.getInstance().dtpmv(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), this.numRows, this.data, yd, 1);
        return y;
    }

    @Override
    public Vector transMult(double alpha, Vector x2, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x2, y);
        }
        this.checkTransMultAdd(x2, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x2);
        BLAS.getInstance().dtpmv(this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), this.numRows, this.data, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X2) {
        return this.solve(B, X2, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.solve(B, X2);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X2) {
        return this.solve(B, X2, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.transSolve(B, X2);
        return x2;
    }

    Matrix solve(Matrix B, Matrix X2, Transpose trans) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dtptrs(this.uplo.netlib(), trans.netlib(), this.diag.netlib(), this.numRows, X2.numColumns(), this.data, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new TriangPackMatrixIterator();
    }

    private class TriangPackMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private TriangPackMatrixIterator() {
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (AbstractTriangPackMatrix.this.uplo == UpLo.Lower) {
                if (this.row < AbstractTriangPackMatrix.this.numRows - 1) {
                    ++this.row;
                } else {
                    ++this.column;
                    this.row = this.column;
                }
            } else if (this.row < this.column) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }
    }
}

