/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Side;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

abstract class AbstractSymmDenseMatrix
extends AbstractDenseMatrix {
    private UpLo uplo;

    AbstractSymmDenseMatrix(int n, UpLo uplo) {
        super(n, n);
        this.uplo = uplo;
    }

    AbstractSymmDenseMatrix(Matrix A, UpLo uplo) {
        this(A, true, uplo);
    }

    AbstractSymmDenseMatrix(Matrix A, boolean deep, UpLo uplo) {
        super(A, deep);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Symmetric matrix must be square");
        }
        this.uplo = uplo;
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.multAdd(alpha, B, C);
        }
        this.checkMultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dsymm(Side.Left.netlib(), this.uplo.netlib(), C.numRows(), C.numColumns(), alpha, this.data, Math.max(1, C.numRows()), Bd, Math.max(1, C.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B, Matrix C) {
        return this.multAdd(alpha, B, C);
    }

    @Override
    public Matrix rank1(double alpha, Vector x2, Vector y) {
        if (x2 != y) {
            throw new IllegalArgumentException("x != y");
        }
        if (!(x2 instanceof DenseVector)) {
            return super.rank1(alpha, x2, y);
        }
        this.checkRank1(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        BLAS.getInstance().dsyr(this.uplo.netlib(), this.numRows, alpha, xd, 1, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix rank2(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank2(alpha, x2, y);
        }
        this.checkRank2(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dsyr2(this.uplo.netlib(), this.numRows, alpha, xd, 1, yd, 1, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y) {
        if (!(x2 instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y);
        }
        this.checkMultAdd(x2, y);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dsymv(this.uplo.netlib(), this.numRows, alpha, this.data, Math.max(1, this.numRows), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y) {
        return this.multAdd(alpha, x2, y);
    }

    @Override
    public Matrix rank1(double alpha, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.rank1(alpha, C);
        }
        this.checkRank1(C);
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dsyrk(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.numRows, C.numColumns(), alpha, Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix transRank1(double alpha, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.transRank1(alpha, C);
        }
        this.checkTransRank1(C);
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dsyrk(this.uplo.netlib(), Transpose.Transpose.netlib(), this.numRows, this.numRows, alpha, Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix rank2(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.rank2(alpha, B, C);
        }
        this.checkRank2(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dsyr2k(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.numRows, B.numColumns(), alpha, Bd, Math.max(1, this.numRows), Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix transRank2(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transRank2(alpha, B, C);
        }
        this.checkTransRank2(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dsyr2k(this.uplo.netlib(), Transpose.Transpose.netlib(), this.numRows, B.numRows(), alpha, Bd, Math.max(1, B.numRows()), Cd, Math.max(1, B.numRows()), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X2) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        double[] newData = (double[])this.data.clone();
        int[] ipiv = new int[this.numRows];
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dsysv(this.uplo.netlib(), this.numRows, X2.numColumns(), newData, Matrices.ld(this.numRows), ipiv, Xd, Matrices.ld(this.numRows), work, -1, info);
        int lwork = -1;
        lwork = info.val != 0 ? 1 : Math.max((int)work[0], 1);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dsysv(this.uplo.netlib(), this.numRows, X2.numColumns(), newData, Matrices.ld(this.numRows), ipiv, Xd, Matrices.ld(this.numRows), work, lwork, info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    @Override
    public Vector solve(Vector b, Vector x2) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X2 = new DenseMatrix(x2, false);
        this.solve(B, X2);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X2) {
        return this.solve(B, X2);
    }

    @Override
    public Vector transSolve(Vector b, Vector x2) {
        return this.solve(b, x2);
    }

    Matrix SPDsolve(Matrix B, Matrix X2) {
        if (!(X2 instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X2);
        double[] Xd = ((DenseMatrix)X2).getData();
        X2.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dposv(this.uplo.netlib(), this.numRows, X2.numColumns(), (double[])this.data.clone(), Matrices.ld(this.numRows), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixNotSPDException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X2;
    }

    @Override
    public Matrix transpose() {
        return this;
    }
}

