/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jniinchi;

import net.sf.jniinchi.INCHI_RADICAL;

public class JniInchiAtom {
    protected static final int ISOTOPIC_SHIFT_FLAG = 10000;
    private double x;
    private double y;
    private double z;
    private String elname;
    private int implicitH = -1;
    private int implicitP = 0;
    private int implicitD = 0;
    private int implicitT = 0;
    private int isotopic_mass = 0;
    private INCHI_RADICAL radical = INCHI_RADICAL.NONE;
    private int charge = 0;

    public JniInchiAtom(double x2, double y, double z, String el) {
        this.x = x2;
        this.y = y;
        this.z = z;
        if (el == null) {
            throw new NullPointerException("Chemical element must not be null");
        }
        this.elname = el;
    }

    public JniInchiAtom(String el) {
        this(0.0, 0.0, 0.0, el);
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public void setRadical(INCHI_RADICAL radical) {
        this.radical = radical;
    }

    public void setIsotopicMass(int mass) {
        this.isotopic_mass = mass;
    }

    public void setIsotopicMassShift(int shift) {
        this.isotopic_mass = 10000 + shift;
    }

    public void setImplicitH(int n) {
        this.implicitH = n;
    }

    public void setImplicitProtium(int n) {
        this.implicitP = n;
    }

    public void setImplicitDeuterium(int n) {
        this.implicitD = n;
    }

    public void setImplicitTritium(int n) {
        this.implicitT = n;
    }

    public String getElementType() {
        return this.elname;
    }

    public int getCharge() {
        return this.charge;
    }

    public INCHI_RADICAL getRadical() {
        return this.radical;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getImplicitH() {
        return this.implicitH;
    }

    public int getImplicitProtium() {
        return this.implicitP;
    }

    public int getImplicitDeuterium() {
        return this.implicitD;
    }

    public int getImplicitTritium() {
        return this.implicitT;
    }

    public int getIsotopicMass() {
        return this.isotopic_mass;
    }

    int getInchiRadical() {
        return this.radical.getIndx();
    }

    void setInchiRadical(int radical) {
        this.radical = INCHI_RADICAL.getValue(radical);
    }

    public String getDebugString() {
        return "InChI Atom: " + this.elname + " [" + this.x + "," + this.y + "," + this.z + "] " + "Charge:" + this.charge + " // " + "Iso Mass:" + this.isotopic_mass + " // " + "Implicit H:" + this.implicitH + " P:" + this.implicitP + " D:" + this.implicitD + " T:" + this.implicitT + " // Radical: " + (Object)((Object)this.radical);
    }

    public void debug() {
        System.out.println(this.getDebugString());
    }
}

