/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.repository;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.repository.ArtefactRepository;
import net.sf.jnati.deploy.source.ArtefactSource;
import net.sf.jnati.deploy.source.FileSource;
import net.sf.jnati.deploy.source.JarSource;
import net.sf.jnati.deploy.source.UrlSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathRepository
extends ArtefactRepository {
    private static final Logger LOG = Logger.getLogger(ClasspathRepository.class);
    private static final String FS = "/";
    private static final String METAINF = "META-INF";
    private static final String MANIFEST = "MANIFEST.xml";

    private static String getManifestPath(Artefact artefact) {
        String path = ClasspathRepository.getArtefactPath(artefact) + MANIFEST;
        return path;
    }

    private static String getArtefactPath(Artefact artefact) {
        String path = "META-INF/" + artefact.getId() + FS + artefact.getVersion() + FS + artefact.getOsArch() + FS;
        return path;
    }

    @Override
    public List<? extends ArtefactSource> getArtefactSource(Artefact artefact) throws IOException {
        LOG.info("Searching classpath for: " + artefact);
        String name = ClasspathRepository.getManifestPath(artefact);
        Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(name);
        ArrayList<ArtefactSource> list2 = new ArrayList<ArtefactSource>();
        for (URL url : Collections.list(enumeration)) {
            LOG.trace("Manifest location: " + url);
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                list2.add(this.getFileSource(url, artefact));
                continue;
            }
            if ("jar".equalsIgnoreCase(protocol)) {
                list2.add(this.getJarSource(url, artefact));
                continue;
            }
            LOG.warn("Unknown URL protocol: " + protocol);
            list2.add(this.getUrlSource(url, artefact, ClasspathRepository.getArtefactPath(artefact)));
        }
        return list2;
    }

    private ArtefactSource getUrlSource(URL url, Artefact artefact, String artefactPath) {
        UrlSource urlSource = new UrlSource(url, artefact, artefactPath);
        return urlSource;
    }

    private ArtefactSource getFileSource(URL url, Artefact artefact) {
        String u = this.getString(url);
        String filename = u.substring(5);
        File file = new File(filename);
        File dir2 = file.getParentFile();
        return new FileSource(dir2, artefact);
    }

    private ArtefactSource getJarSource(URL url, Artefact artefact) throws IOException {
        String u = this.getString(url);
        String filename = u.substring(9, u.indexOf(33));
        File file = new File(filename);
        return new JarSource(file, artefact);
    }

    private String getString(URL url) {
        try {
            return URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported!", e);
        }
    }
}

