/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.file.DictionaryCatalogSet;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.ObjectDictionaryFile;
import net.didion.jwnl.princeton.file.PrincetonObjectDictionaryFile;

public class DictionaryToMap {
    private DictionaryCatalogSet _destFiles;

    public DictionaryToMap(String destDirectory, String propFile) throws JWNLException, IOException {
        JWNL.initialize(new FileInputStream(propFile));
        this._destFiles = new DictionaryCatalogSet(destDirectory, PrincetonObjectDictionaryFile.class);
    }

    public void convert() throws JWNLException, IOException {
        this._destFiles.open();
        boolean canClearCache = Dictionary.getInstance() instanceof AbstractCachingDictionary && ((AbstractCachingDictionary)Dictionary.getInstance()).isCachingEnabled();
        for (DictionaryFileType fileType : DictionaryFileType.getAllDictionaryFileTypes()) {
            for (POS pos : POS.getAllPOS()) {
                System.out.println("Converting " + pos + " " + fileType + " file...");
                this.serialize(pos, fileType);
            }
            if (canClearCache) {
                ((AbstractCachingDictionary)Dictionary.getInstance()).clearCache(fileType.getElementType());
            }
            System.gc();
        }
        this._destFiles.close();
    }

    private Iterator getIterator(POS pos, DictionaryFileType fileType) throws JWNLException {
        if (fileType == DictionaryFileType.DATA) {
            return Dictionary.getInstance().getSynsetIterator(pos);
        }
        if (fileType == DictionaryFileType.INDEX) {
            return Dictionary.getInstance().getIndexWordIterator(pos);
        }
        if (fileType == DictionaryFileType.EXCEPTION) {
            return Dictionary.getInstance().getExceptionIterator(pos);
        }
        throw new IllegalArgumentException();
    }

    private void serialize(POS pos, DictionaryFileType fileType) throws JWNLException, IOException {
        ObjectDictionaryFile file = (ObjectDictionaryFile)this._destFiles.getDictionaryFile(pos, fileType);
        int count2 = 0;
        Iterator itr = this.getIterator(pos, fileType);
        while (itr.hasNext()) {
            if (++count2 % 10000 == 0) {
                System.out.println("Counted and cached word " + count2 + "...");
            }
            itr.next();
        }
        HashMap<Object, DictionaryElement> map2 = new HashMap<Object, DictionaryElement>((int)Math.ceil((float)count2 / 0.9f) + 1, 0.9f);
        Iterator listItr = this.getIterator(pos, fileType);
        while (listItr.hasNext()) {
            DictionaryElement elt = (DictionaryElement)listItr.next();
            map2.put(elt.getKey(), elt);
        }
        file.writeObject(map2);
        file.close();
        map2 = null;
        file = null;
        System.gc();
        Runtime rt = Runtime.getRuntime();
        System.out.println("total mem: " + rt.totalMemory() / 1024L + "K free mem: " + rt.freeMemory() / 1024L + "K");
        System.out.println("Successfully serialized...");
    }

    public static void main(String[] args) {
        String destinationDirectory = null;
        String propertyFile = null;
        if (args.length == 2) {
            destinationDirectory = args[0];
            propertyFile = args[1];
        } else {
            System.out.println("java DictionaryToMap <destination directory> <properties file>");
            System.exit(-1);
        }
        try {
            new DictionaryToMap(destinationDirectory, propertyFile).convert();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

