/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util.cache;

import java.util.HashMap;
import java.util.Map;
import net.didion.jwnl.util.cache.Cache;

public abstract class CacheSet {
    public static final int DEFAULT_CACHE_CAPACITY = 1000;
    private Map _caches = new HashMap();

    public CacheSet(Object[] keys) {
        this(keys, 1000);
    }

    public CacheSet(Object[] keys, int size2) {
        for (int i = 0; i < keys.length; ++i) {
            this.addCache(keys[i], size2);
        }
    }

    public CacheSet(Object[] keys, int[] sizes) {
        for (int i = 0; i < keys.length; ++i) {
            this.addCache(keys[i], sizes[i]);
        }
    }

    protected abstract Cache createCache(int var1);

    public void addCache(Object key) {
        this.addCache(key, 1000);
    }

    public void addCache(Object key, int size2) {
        this._caches.put(key, this.createCache(size2));
    }

    public void cacheObject(Object cacheKey, Object key, Object value2) {
        this.getCache(cacheKey).put(key, value2);
    }

    public Object getCachedObject(Object cacheKey, Object key) {
        return this.getCache(cacheKey).get(key);
    }

    public void clearCache(Object key) {
        this.getCache(key).clear();
    }

    public int getCacheSize(Object cacheKey) {
        return this.getCache(cacheKey).getSize();
    }

    public int getCacheCapacity(Object cacheKey) {
        return this.getCache(cacheKey).getCapacity();
    }

    public int setCacheCapacity(Object cacheKey, int capacity) {
        return this.getCache(cacheKey).setCapacity(capacity);
    }

    public int getSize() {
        return this._caches.size();
    }

    protected Cache getCache(Object cacheKey) {
        return (Cache)this._caches.get(cacheKey);
    }
}

