/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.util.DeepCloneable;

public class TypeCheckingList
implements List,
DeepCloneable {
    private List _list;
    private Class _type;
    private Collection _lastCheckedCollection = null;

    public TypeCheckingList(Class type) {
        this(new ArrayList(), type);
    }

    public TypeCheckingList(List backingList, Class type) {
        this.init(backingList, type);
    }

    protected TypeCheckingList(List backingList, Class type, Class parentType) {
        if (!parentType.isAssignableFrom(type)) {
            throw new JWNLRuntimeException("UTILS_EXCEPTION_001", new Object[]{type, parentType});
        }
        this.init(backingList, type);
    }

    private void init(List backingList, Class type) {
        this._type = type;
        if (!backingList.isEmpty()) {
            this.typecheck(backingList);
        }
        this._list = backingList;
    }

    public Class getType() {
        return this._type;
    }

    private List getList() {
        return this._list;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new TypeCheckingList(this.copyBackingList(), this.getType());
    }

    protected List copyBackingList() throws CloneNotSupportedException {
        try {
            Method cloneMethod = this.getList().getClass().getMethod("clone", null);
            return (List)cloneMethod.invoke((Object)this.getList(), null);
        }
        catch (Exception ex) {
            throw new CloneNotSupportedException();
        }
    }

    @Override
    public Object deepClone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TypeCheckingList && super.equals(obj);
    }

    @Override
    public boolean add(Object o) {
        this.typecheck(o);
        return this.getList().add(o);
    }

    public void add(int index, Object o) {
        this.typecheck(o);
        this.getList().add(index, o);
    }

    @Override
    public boolean addAll(Collection c) {
        this.typecheck(c);
        return this.getList().addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.typecheck(c);
        return this.getList().addAll(index, c);
    }

    @Override
    public boolean contains(Object o) {
        try {
            this.typecheck(o);
            return this.getList().contains(o);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection c) {
        try {
            this.typecheck(c);
            return this.getList().containsAll(c);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Object set(int index, Object element) {
        this.typecheck(element);
        return this.getList().set(index, element);
    }

    @Override
    public int indexOf(Object o) {
        try {
            this.typecheck(o);
            return this.getList().indexOf(o);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            this.typecheck(o);
            return this.getList().lastIndexOf(o);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            this.typecheck(o);
            return this.getList().remove(o);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public ListIterator listIterator() {
        return this.getTypeCheckingListIterator();
    }

    public ListIterator listIterator(int index) {
        return this.getTypeCheckingListIterator(index);
    }

    protected TypeCheckingListIterator getTypeCheckingListIterator() {
        return this.getTypeCheckingListIterator(0);
    }

    protected TypeCheckingListIterator getTypeCheckingListIterator(int index) {
        return new TypeCheckingListIterator(this.getList().listIterator(index));
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.getList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.getList().toArray(a);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.getList().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.getList().retainAll(c);
    }

    @Override
    public void clear() {
        this.getList().clear();
    }

    public Object get(int index) {
        return this.getList().get(index);
    }

    public Object remove(int index) {
        return this.getList().remove(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    private void typecheck(Object obj) {
        if (!this.getType().isInstance(obj)) {
            throw new JWNLRuntimeException("UTILS_EXCEPTION_003", this.getType());
        }
    }

    private void typecheck(Collection c) {
        if (c != this._lastCheckedCollection) {
            Iterator iterator2 = c.iterator();
            while (iterator2.hasNext()) {
                this.typecheck(iterator2.next());
            }
        }
        this._lastCheckedCollection = c;
    }

    public final class TypeCheckingListIterator
    implements ListIterator {
        private ListIterator _itr;

        private TypeCheckingListIterator(ListIterator itr) {
            this._itr = itr;
        }

        public Class getType() {
            return TypeCheckingList.this.getType();
        }

        public void set(Object o) {
            TypeCheckingList.this.typecheck(o);
            this.getListIterator().set(o);
        }

        public void add(Object o) {
            TypeCheckingList.this.typecheck(o);
            this.getListIterator().add(o);
        }

        @Override
        public boolean hasNext() {
            return this.getListIterator().hasNext();
        }

        @Override
        public Object next() {
            return this.getListIterator().next();
        }

        @Override
        public boolean hasPrevious() {
            return this.getListIterator().hasPrevious();
        }

        public Object previous() {
            return this.getListIterator().previous();
        }

        @Override
        public int nextIndex() {
            return this.getListIterator().nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.getListIterator().previousIndex();
        }

        @Override
        public void remove() {
            this.getListIterator().remove();
        }

        private ListIterator getListIterator() {
            return this._itr;
        }
    }
}

