/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.morph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.morph.AbstractDelegatingOperation;
import net.didion.jwnl.dictionary.morph.BaseFormSet;
import net.didion.jwnl.dictionary.morph.LookupIndexWordOperation;
import net.didion.jwnl.dictionary.morph.Operation;
import net.didion.jwnl.dictionary.morph.Util;
import net.didion.jwnl.util.factory.Param;
import net.didion.jwnl.util.factory.ParamList;

public class TokenizerOperation
extends AbstractDelegatingOperation {
    public static final String TOKEN_OPERATIONS = "token_operations";
    public static final String PHRASE_OPERATIONS = "phrase_operations";
    public static final String DELIMITERS = "delimiters";
    private String[] _delimiters;

    public TokenizerOperation() {
    }

    public TokenizerOperation(String[] delimiters) {
        this._delimiters = delimiters;
    }

    @Override
    protected AbstractDelegatingOperation getInstance(Map params) throws JWNLException {
        ParamList delimiters = (ParamList)params.get(DELIMITERS);
        String[] delimiterArray = null;
        if (delimiters == null || delimiters.getParams().size() == 0) {
            delimiterArray = new String[]{" "};
        } else {
            delimiterArray = new String[delimiters.getParams().size()];
            for (int i = 0; i < delimiters.getParams().size(); ++i) {
                delimiterArray[i] = ((Param)delimiters.getParams().get(i)).getValue();
            }
        }
        return new TokenizerOperation(delimiterArray);
    }

    @Override
    protected String[] getKeys() {
        return new String[]{TOKEN_OPERATIONS, PHRASE_OPERATIONS};
    }

    @Override
    public boolean execute(POS pos, String lemma, BaseFormSet forms) throws JWNLException {
        String[] tokens = Util.split(lemma);
        BaseFormSet[] tokenForms = new BaseFormSet[tokens.length];
        if (!this.hasDelegate(TOKEN_OPERATIONS)) {
            this.addDelegate(TOKEN_OPERATIONS, new Operation[]{new LookupIndexWordOperation()});
        }
        if (!this.hasDelegate(PHRASE_OPERATIONS)) {
            this.addDelegate(PHRASE_OPERATIONS, new Operation[]{new LookupIndexWordOperation()});
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokenForms[i] = new BaseFormSet();
            tokenForms[i].add(tokens[i]);
            this.delegate(pos, tokens[i], tokenForms[i], TOKEN_OPERATIONS);
        }
        boolean foundForms = false;
        for (int i = 0; i < tokenForms.length; ++i) {
            for (int j = tokenForms.length - 1; j >= i; --j) {
                if (!this.tryAllCombinations(pos, tokenForms, i, j, forms)) continue;
                foundForms = true;
            }
        }
        return foundForms;
    }

    private boolean tryAllCombinations(POS pos, BaseFormSet[] tokenForms, int startIndex, int endIndex, BaseFormSet forms) throws JWNLException {
        int length = endIndex - startIndex + 1;
        int[] indexArray = new int[length];
        int[] endArray = new int[length];
        for (int i = 0; i < indexArray.length; ++i) {
            indexArray[i] = 0;
            endArray[i] = tokenForms[startIndex + i].size() - 1;
        }
        boolean foundForms = false;
        block1: while (true) {
            int i;
            String[] tokens = new String[length];
            for (i = 0; i < length; ++i) {
                tokens[i] = tokenForms[i + startIndex].getForm(indexArray[i]);
            }
            for (i = 0; i < this._delimiters.length; ++i) {
                if (!this.tryAllCombinations(pos, tokens, this._delimiters[i], forms)) continue;
                foundForms = true;
            }
            if (Arrays.equals(indexArray, endArray)) break;
            i = length - 1;
            while (true) {
                if (i < 0) continue block1;
                if (indexArray[i] != endArray[i]) {
                    int n = i;
                    indexArray[n] = indexArray[n] + 1;
                    continue block1;
                }
                indexArray[i] = 0;
                --i;
            }
            break;
        }
        return foundForms;
    }

    private boolean tryAllCombinations(POS pos, String[] tokens, String delimiter, BaseFormSet forms) throws JWNLException {
        BitSet bits2 = new BitSet();
        int size2 = tokens.length - 1;
        boolean foundForms = false;
        do {
            String lemma;
            if (!this.delegate(pos, lemma = Util.getLemma(tokens, bits2, delimiter), forms, PHRASE_OPERATIONS)) continue;
            foundForms = true;
        } while (Util.increment(bits2, size2));
        return foundForms;
    }
}

