/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.file.DictionaryCatalog;
import net.didion.jwnl.dictionary.file.DictionaryCatalogSet;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.ObjectDictionaryFile;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;
import net.didion.jwnl.util.factory.Param;

public class MapBackedDictionary
extends Dictionary {
    private static final MessageLog _log = new MessageLog(MapBackedDictionary.class);
    public static final String MORPH = "morphological_processor";
    public static final String FILE_TYPE = "file_type";
    public static final String PATH = "dictionary_path";
    private static final Random _rand = new Random(new Date().getTime());
    private Map _tableMap = new HashMap();

    public MapBackedDictionary() {
    }

    public static void install(String searchDir, Class dictionaryFileType) throws JWNLException {
        MapBackedDictionary.install(searchDir, dictionaryFileType, null);
    }

    public static void install(String searchDir, Class dictionaryFileType, MorphologicalProcessor morph) throws JWNLException {
        MapBackedDictionary.checkFileType(dictionaryFileType);
        DictionaryCatalogSet files = new DictionaryCatalogSet(searchDir, dictionaryFileType);
        MapBackedDictionary.setDictionary(new MapBackedDictionary(files, morph));
        files.close();
    }

    @Override
    public void install(Map params) throws JWNLException {
        Param param2 = (Param)params.get(MORPH);
        MorphologicalProcessor morph = param2 == null ? null : (MorphologicalProcessor)param2.create();
        param2 = (Param)params.get(FILE_TYPE);
        Class<?> dictionaryFileType = null;
        try {
            dictionaryFileType = Class.forName(param2.getValue());
        }
        catch (Exception ex) {
            throw new JWNLException("DICTIONARY_EXCEPTION_003", param2.getValue(), (Throwable)ex);
        }
        MapBackedDictionary.checkFileType(dictionaryFileType);
        param2 = (Param)params.get(PATH);
        String path = param2.getValue();
        MapBackedDictionary.install(path, dictionaryFileType, morph);
    }

    private static void checkFileType(Class c) {
        if (!ObjectDictionaryFile.class.isAssignableFrom(c)) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_010", c);
        }
    }

    private MapBackedDictionary(DictionaryCatalogSet files, MorphologicalProcessor morph) throws JWNLException {
        super(morph);
        if (!files.isOpen()) {
            try {
                files.open();
            }
            catch (Exception ex) {
                throw new JWNLException("DICTIONARY_EXCEPTION_019", ex);
            }
        }
        _log.log(MessageLogLevel.INFO, "Loading MapBackedDictionary");
        if (_log.isLevelEnabled(MessageLogLevel.TRACE)) {
            _log.log(MessageLogLevel.TRACE, "Starting Memory: " + Runtime.getRuntime().freeMemory());
        }
        for (DictionaryFileType fileType : DictionaryFileType.getAllDictionaryFileTypes()) {
            DictionaryCatalog catalog = files.get(fileType);
            for (POS pos : POS.getAllPOS()) {
                _log.log(MessageLogLevel.INFO, "Loading " + pos + " " + fileType);
                this.putTable(pos, fileType, this.loadDictFile(catalog.get(pos)));
                if (!_log.isLevelEnabled(MessageLogLevel.TRACE)) continue;
                _log.log(MessageLogLevel.TRACE, "Current Memory: " + Runtime.getRuntime().freeMemory());
            }
        }
    }

    @Override
    public IndexWord getIndexWord(POS pos, String lemma) {
        return (IndexWord)this.getTable(pos, DictionaryFileType.INDEX).get(MapBackedDictionary.prepareQueryString(lemma));
    }

    @Override
    public Iterator getIndexWordIterator(POS pos, String substring) {
        substring = MapBackedDictionary.prepareQueryString(substring);
        Iterator itr = this.getIndexWordIterator(pos);
        String temp = null;
        while (itr.hasNext()) {
            IndexWord word = (IndexWord)itr.next();
            String w = word.getLemma();
            if (w.indexOf(substring) == -1) continue;
            temp = w;
            break;
        }
        return new IndexWordIterator(itr, substring, temp);
    }

    @Override
    public Iterator getIndexWordIterator(POS pos) {
        return this.getIterator(this.getTable(pos, DictionaryFileType.INDEX));
    }

    @Override
    public IndexWord getRandomIndexWord(POS pos) throws JWNLException {
        int index = _rand.nextInt(this.getTable(pos, DictionaryFileType.INDEX).size());
        Iterator itr = this.getIndexWordIterator(pos);
        for (int i = 0; i < index && itr.hasNext(); ++i) {
            itr.next();
        }
        return itr.hasNext() ? (IndexWord)itr.next() : null;
    }

    @Override
    public Iterator getSynsetIterator(POS pos) {
        return this.getIterator(this.getTable(pos, DictionaryFileType.DATA));
    }

    @Override
    public Iterator getExceptionIterator(POS pos) {
        return this.getIterator(this.getTable(pos, DictionaryFileType.EXCEPTION));
    }

    private Iterator getIterator(Map map2) {
        return map2.values().iterator();
    }

    @Override
    public Synset getSynsetAt(POS pos, long offset) {
        return (Synset)this.getTable(pos, DictionaryFileType.DATA).get(new Long(offset));
    }

    @Override
    public Exc getException(POS pos, String derivation) {
        return (Exc)this.getTable(pos, DictionaryFileType.EXCEPTION).get(MapBackedDictionary.prepareQueryString(derivation));
    }

    @Override
    public void close() {
        this._tableMap = null;
    }

    private Map loadDictFile(DictionaryFile file) throws JWNLException {
        try {
            return (Map)((ObjectDictionaryFile)file).readObject();
        }
        catch (Exception ex) {
            throw new JWNLException("DICTIONARY_EXCEPTION_020", file.getFile(), (Throwable)ex);
        }
    }

    private void putTable(POS pos, DictionaryFileType fileType, Map table) {
        this._tableMap.put(new MapTableKey(pos, fileType), table);
    }

    private Map getTable(POS pos, DictionaryFileType fileType) {
        return (Map)this._tableMap.get(new MapTableKey(pos, fileType));
    }

    public int getUsageCount(long offset, String lemma) {
        return 0;
    }

    public String getSenseKey(long offset, String lemma) {
        return null;
    }

    private static final class IndexWordIterator
    implements Iterator {
        private Iterator _itr;
        private String _searchString;
        private String _startWord;

        public IndexWordIterator(Iterator itr, String searchString, String startWord) {
            this._itr = itr;
            this._searchString = searchString;
            this._startWord = startWord;
        }

        @Override
        public boolean hasNext() {
            return this._startWord != null;
        }

        public Object next() {
            if (this.hasNext()) {
                String thisWord = this._startWord;
                this._startWord = null;
                while (this._itr.hasNext()) {
                    IndexWord word = (IndexWord)this._itr.next();
                    String w = word.getLemma();
                    if (w.indexOf(this._searchString) == -1) continue;
                    this._startWord = w;
                    break;
                }
                return thisWord;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class MapTableKey {
        private POS _pos;
        private DictionaryFileType _fileType;

        private MapTableKey(POS pos, DictionaryFileType fileType) {
            this._pos = pos;
            this._fileType = fileType;
        }

        public int hashCode() {
            return this._pos.hashCode() ^ this._fileType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MapTableKey) {
                MapTableKey k = (MapTableKey)obj;
                return this._pos.equals(k._pos) && this._fileType.equals(k._fileType);
            }
            return false;
        }
    }
}

