/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.DictionaryElementType;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.POSKey;
import net.didion.jwnl.util.cache.Cache;
import net.didion.jwnl.util.cache.CacheSet;
import net.didion.jwnl.util.cache.LRUCache;

public abstract class AbstractCachingDictionary
extends Dictionary {
    private DictionaryCacheSet _caches;
    private boolean _isCachingEnabled;

    protected AbstractCachingDictionary() {
        this(false);
    }

    protected AbstractCachingDictionary(boolean enableCaching) {
        this.setCachingEnabled(enableCaching);
    }

    protected AbstractCachingDictionary(MorphologicalProcessor morph) {
        this(morph, false);
    }

    protected AbstractCachingDictionary(MorphologicalProcessor morph, boolean enableCaching) {
        super(morph);
        this.setCachingEnabled(enableCaching);
    }

    public boolean isCachingEnabled() {
        return this._isCachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this._isCachingEnabled = cachingEnabled;
    }

    public int getCacheSizes(DictionaryElementType type) {
        return this.getCaches().getCacheSize(type);
    }

    public int getCacheCapacity(DictionaryElementType type) {
        return this.getCaches().getCacheCapacity(type);
    }

    public void setCacheCapacity(int size2) {
        Iterator itr = DictionaryElementType.getAllDictionaryElementTypes().iterator();
        while (itr.hasNext()) {
            this.setCacheCapacity((DictionaryElementType)itr.next(), size2);
        }
    }

    public void setCacheCapacity(DictionaryElementType type, int size2) {
        this.getCaches().setCacheCapacity(type, size2);
    }

    public void clearCache() {
        Iterator itr = DictionaryElementType.getAllDictionaryElementTypes().iterator();
        while (itr.hasNext()) {
            this.clearCache((DictionaryElementType)itr.next());
        }
    }

    public void clearCache(DictionaryElementType elementType) {
        if (this.isCachingEnabled()) {
            this.getCaches().clearCache(elementType);
        }
    }

    protected void cacheIndexWord(POSKey key, IndexWord word) {
        this.cache(DictionaryElementType.INDEX_WORD, key, word);
    }

    protected IndexWord getCachedIndexWord(POSKey key) {
        return (IndexWord)this.getCached(DictionaryElementType.INDEX_WORD, key);
    }

    protected void cacheSynset(POSKey key, Synset synset) {
        this.cache(DictionaryElementType.SYNSET, key, synset);
    }

    protected Synset getCachedSynset(POSKey key) {
        return (Synset)this.getCached(DictionaryElementType.SYNSET, key);
    }

    protected void cacheException(POSKey key, Exc exception) {
        this.cache(DictionaryElementType.EXCEPTION, key, exception);
    }

    protected Exc getCachedException(POSKey key) {
        return (Exc)this.getCached(DictionaryElementType.EXCEPTION, key);
    }

    private DictionaryCacheSet getCaches() {
        if (!this.isCachingEnabled()) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_022");
        }
        if (this._caches == null) {
            this._caches = new DictionaryCacheSet();
        }
        return this._caches;
    }

    private void cache(DictionaryElementType fileType, POSKey key, Object obj) {
        if (this.isCachingEnabled()) {
            this.getCaches().cacheObject(fileType, (Object)key, obj);
        }
    }

    private Object getCached(DictionaryElementType fileType, POSKey key) {
        if (this.isCachingEnabled()) {
            return this.getCaches().getCachedObject(fileType, (Object)key);
        }
        return null;
    }

    private static final class ObservableCache
    extends LRUCache {
        private Observable _observable = new Observable();

        public ObservableCache(int capacity) {
            super(capacity);
        }

        public void addObserver(Observer obs) {
            this._observable.addObserver(obs);
        }

        @Override
        public Object remove(Object key) {
            Object obj = super.remove(key);
            this._observable.notifyObservers(obj);
            return obj;
        }
    }

    private static final class DictionaryCacheSet
    extends CacheSet
    implements Observer {
        private Map _lemmaToOffsetMaps;

        public DictionaryCacheSet() {
            super(DictionaryElementType.getAllDictionaryElementTypes().toArray());
            this.initLemmaToOffsetMaps();
        }

        public DictionaryCacheSet(int[] sizes) {
            super(DictionaryElementType.getAllDictionaryElementTypes().toArray(), sizes);
            this.initLemmaToOffsetMaps();
        }

        public Object getCachedObject(DictionaryElementType fileType, Object key) {
            if (((POSKey)key).isLemmaKey()) {
                key = this.getMap(fileType).get(key);
            }
            return key == null ? null : super.getCachedObject(fileType, key);
        }

        public void cacheObject(DictionaryElementType fileType, Object key, Object value2) {
            if (value2 instanceof IndexWord) {
                IndexWord word = (IndexWord)value2;
                this.getMap(DictionaryElementType.INDEX_WORD).put(new POSKey(word.getPOS(), word.getLemma()), key);
            } else if (value2 instanceof Exc) {
                Exc exc = (Exc)value2;
                this.getMap(DictionaryElementType.EXCEPTION).put(new POSKey(exc.getPOS(), exc.getLemma()), key);
            }
            super.cacheObject(fileType, key, value2);
        }

        public void clearCache(DictionaryElementType fileType) {
            Map m = this.getMap(fileType);
            if (m != null) {
                m.clear();
            }
            super.clearCache(fileType);
        }

        @Override
        public void update(Observable obs, Object obj) {
            if (obj instanceof IndexWord) {
                IndexWord word = (IndexWord)obj;
                this.removeLemma(DictionaryElementType.INDEX_WORD, word.getLemma(), word.getPOS());
            } else if (obj instanceof Exc) {
                Exc exc = (Exc)obj;
                this.removeLemma(DictionaryElementType.EXCEPTION, exc.getLemma(), exc.getPOS());
            }
        }

        private void initLemmaToOffsetMaps() {
            this._lemmaToOffsetMaps = new HashMap(2);
            this._lemmaToOffsetMaps.put(DictionaryElementType.INDEX_WORD, new HashMap(this.getCache(DictionaryElementType.INDEX_WORD).getCapacity()));
            this._lemmaToOffsetMaps.put(DictionaryElementType.EXCEPTION, new HashMap(this.getCache(DictionaryElementType.EXCEPTION).getCapacity()));
        }

        private void removeLemma(DictionaryElementType fileType, String lemma, POS pos) {
            ((Map)this._lemmaToOffsetMaps.get(fileType)).remove(new POSKey(pos, lemma));
        }

        private Map getMap(DictionaryElementType fileType) {
            return (Map)this._lemmaToOffsetMaps.get(fileType);
        }

        @Override
        protected Cache createCache(int size2) {
            ObservableCache cache = new ObservableCache(size2);
            cache.addObserver(this);
            return cache;
        }
    }
}

