/*
 * Decompiled with CFR 0.152.
 */
package hepple.postag;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import hepple.postag.InvalidRuleException;
import hepple.postag.Lexicon;
import hepple.postag.Rule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class POSTagger {
    static /* synthetic */ Class class$hepple$postag$POSTagger;
    private String[] deflex_CD;
    private String[] deflex_JJ;
    private String[] deflex_NN;
    private String[] deflex_NNP;
    private String[] deflex_NNS;
    private String[] deflex_RB;
    private String[] deflex_VBG;
    private String encoding;
    public String[][] lexBuff;
    Lexicon lexicon;
    protected Map rules;
    static final String staart = "STAART";
    private String[] staartLex = new String[]{"STAART"};
    public String[] tagBuff;
    public String[] wordBuff;

    public POSTagger(URL lexiconURL, URL rulesURL) throws InvalidRuleException, IOException {
        this.deflex_NNP = new String[]{"NNP"};
        this.deflex_JJ = new String[]{"JJ"};
        this.deflex_CD = new String[]{"CD"};
        this.deflex_NNS = new String[]{"NNS"};
        this.deflex_RB = new String[]{"RB"};
        this.deflex_VBG = new String[]{"VBG"};
        this.deflex_NN = new String[]{"NN"};
        this.wordBuff = new String[]{staart, staart, staart, staart, staart, staart, staart};
        this.tagBuff = new String[]{staart, staart, staart, staart, staart, staart, staart};
        this.lexBuff = new String[][]{this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex, this.staartLex};
        this.lexicon = new Lexicon(lexiconURL);
        this.lexicon.setEncoding(this.encoding);
        this.rules = new HashMap();
        this.readRules(rulesURL);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private String[] classifyWord(String wd) {
        if (wd == staart) {
            return this.staartLex;
        }
        List categories = (List)this.lexicon.get(wd);
        if (categories != null) {
            String[] result2 = new String[categories.size()];
            int i = 0;
            while (i < result2.length) {
                result2[i] = (String)categories.get(i);
                ++i;
            }
            return result2;
        }
        if ('A' <= wd.charAt(0) && wd.charAt(0) <= 'Z') {
            return this.deflex_NNP;
        }
        int i = 1;
        while (i < wd.length() - 1) {
            if (wd.charAt(i) == '-') {
                return this.deflex_JJ;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < wd.length()) {
            if ('0' <= wd.charAt(i2) && wd.charAt(i2) <= '9') {
                return this.deflex_CD;
            }
            ++i2;
        }
        if (wd.endsWith("ed") || wd.endsWith("us") || wd.endsWith("ic") || wd.endsWith("ble") || wd.endsWith("ive") || wd.endsWith("ary") || wd.endsWith("ful") || wd.endsWith("ical") || wd.endsWith("less")) {
            return this.deflex_JJ;
        }
        if (wd.endsWith("s")) {
            return this.deflex_NNS;
        }
        if (wd.endsWith("ly")) {
            return this.deflex_RB;
        }
        if (wd.endsWith("ing")) {
            return this.deflex_VBG;
        }
        return this.deflex_NN;
    }

    public Rule createNewRule(String ruleId) throws InvalidRuleException {
        try {
            String className = "hepple.postag.rules.Rule_" + ruleId;
            Class<?> ruleClass = Class.forName(className);
            return (Rule)ruleClass.newInstance();
        }
        catch (Exception e) {
            throw new InvalidRuleException("Could not create rule " + ruleId + "!\n" + e.toString());
        }
    }

    private static void help() {
        System.out.println("NAME\nHepTag - a Part-of-Speech tagger\nsee http://www.dcs.shef.ac.uk/~hepple/papers/acl00/abstract.html \n\nSYNOPSIS\n\tjava -jar heptag.jar [options] file1 [file2 ...]\n\nOPTIONS:\n-h, --help \n\tdisplays this message\n-l, --lexicon <lexicon file>\n\tuses specified lexicon\n-r, --rules <rules file>\n\tuses specified rules");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            POSTagger.help();
        }
        try {
            URL lexiconURL;
            int opt2;
            LongOpt[] options = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("lexicon", 0, null, 108), new LongOpt("rules", 0, null, 114)};
            Getopt getopt = new Getopt("HepTag", args, "hl:r:", options);
            String lexiconUrlString = null;
            String rulesUrlString = null;
            while ((opt2 = getopt.getopt()) != -1) {
                void var5_6;
                switch (var5_6) {
                    case 104: {
                        POSTagger.help();
                        System.exit(0);
                        break;
                    }
                    case 108: {
                        lexiconUrlString = getopt.getOptarg();
                        break;
                    }
                    case 114: {
                        rulesUrlString = getopt.getOptarg();
                        break;
                    }
                    default: {
                        System.err.println("Invalid option " + args[getopt.getOptind() - 1] + "!");
                        System.exit(1);
                    }
                }
            }
            String[] fileNames = new String[args.length - getopt.getOptind()];
            int i = getopt.getOptind();
            while (i < args.length) {
                fileNames[i - getopt.getOptind()] = args[i];
                ++i;
            }
            URL uRL = lexiconUrlString == null ? (class$hepple$postag$POSTagger == null ? (class$hepple$postag$POSTagger = POSTagger.class$("hepple.postag.POSTagger")) : class$hepple$postag$POSTagger).getResource("/hepple/resources/sample_lexicon") : (lexiconURL = new File(lexiconUrlString).toURL());
            URL rulesURL = rulesUrlString == null ? (class$hepple$postag$POSTagger == null ? (class$hepple$postag$POSTagger = POSTagger.class$("hepple.postag.POSTagger")) : class$hepple$postag$POSTagger).getResource("/hepple/resources/sample_ruleset.big") : new File(rulesUrlString).toURL();
            POSTagger tagger = new POSTagger(lexiconURL, rulesURL);
            int i2 = 0;
            while (i2 < fileNames.length) {
                String file = fileNames[i2];
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null) {
                    StringTokenizer tokens = new StringTokenizer(line);
                    ArrayList<String> sentence = new ArrayList<String>();
                    while (tokens.hasMoreTokens()) {
                        sentence.add(tokens.nextToken());
                    }
                    ArrayList<ArrayList<String>> sentences = new ArrayList<ArrayList<String>>();
                    sentences.add(sentence);
                    List result2 = tagger.runTagger(sentences);
                    Iterator iter2 = result2.iterator();
                    while (iter2.hasNext()) {
                        List sentenceFromTagger = (List)iter2.next();
                        Iterator sentIter = sentenceFromTagger.iterator();
                        while (sentIter.hasNext()) {
                            String[] tag = (String[])sentIter.next();
                            System.out.print(tag[0] + "/" + tag[1]);
                            if (sentIter.hasNext()) {
                                System.out.print(" ");
                                continue;
                            }
                            System.out.println();
                        }
                    }
                    line = reader.readLine();
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean oneStep(String word, List taggedSentence) {
        String taggedWord;
        int i = 1;
        while (i < 7) {
            this.wordBuff[i - 1] = this.wordBuff[i];
            this.tagBuff[i - 1] = this.tagBuff[i];
            this.lexBuff[i - 1] = this.lexBuff[i];
            ++i;
        }
        this.wordBuff[6] = word;
        this.lexBuff[6] = this.classifyWord(word);
        this.tagBuff[6] = this.lexBuff[6][0];
        List rulesToApply = (List)this.rules.get(this.lexBuff[3][0]);
        if (rulesToApply != null && rulesToApply.size() > 0) {
            Iterator rulesIter = rulesToApply.iterator();
            while (rulesIter.hasNext()) {
                if (!((Rule)rulesIter.next()).apply(this)) continue;
                break;
            }
        }
        if ((taggedWord = this.wordBuff[0]) != staart) {
            taggedSentence.add(new String[]{taggedWord, this.tagBuff[0]});
            if (this.wordBuff[1] == staart) {
                return true;
            }
        }
        return false;
    }

    private static List readInput(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        ArrayList result2 = new ArrayList();
        while (line != null) {
            StringTokenizer tokens = new StringTokenizer(line);
            ArrayList<String> sentence = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                sentence.add(tokens.nextToken());
            }
            result2.add(sentence);
            line = reader.readLine();
        }
        return result2;
    }

    public void readRules(URL rulesURL) throws IOException, InvalidRuleException {
        BufferedReader rulesReader = this.encoding == null ? new BufferedReader(new InputStreamReader(rulesURL.openStream())) : new BufferedReader(new InputStreamReader(rulesURL.openStream(), this.encoding));
        String line = rulesReader.readLine();
        while (line != null) {
            ArrayList<String> ruleParts = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(line);
            while (tokens.hasMoreTokens()) {
                ruleParts.add(tokens.nextToken());
            }
            if (ruleParts.size() < 3) {
                throw new InvalidRuleException(line);
            }
            Rule newRule = this.createNewRule((String)ruleParts.get(2));
            newRule.initialise(ruleParts);
            ArrayList<Rule> existingRules = (ArrayList<Rule>)this.rules.get(newRule.from);
            if (existingRules == null) {
                existingRules = new ArrayList<Rule>();
                this.rules.put(newRule.from, existingRules);
            }
            existingRules.add(newRule);
            line = rulesReader.readLine();
        }
    }

    public List runTagger(List sentences) {
        ArrayList output2 = new ArrayList();
        ArrayList taggedSentence = new ArrayList();
        Iterator sentencesIter = sentences.iterator();
        while (sentencesIter.hasNext()) {
            List sentence = (List)sentencesIter.next();
            Iterator wordsIter = sentence.iterator();
            while (wordsIter.hasNext()) {
                String newWord = (String)wordsIter.next();
                if (!this.oneStep(newWord, taggedSentence)) continue;
                output2.add(taggedSentence);
                taggedSentence = new ArrayList();
            }
            int i = 0;
            while (i < 2) {
                if (this.oneStep(staart, taggedSentence)) {
                    output2.add(taggedSentence);
                    taggedSentence = new ArrayList();
                }
                ++i;
            }
        }
        int i = 0;
        while (i < 4) {
            if (this.oneStep(staart, taggedSentence)) {
                output2.add(taggedSentence);
                taggedSentence = new ArrayList();
            }
            ++i;
        }
        return output2;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void showRules() {
        System.out.println(this.rules);
    }
}

