/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TShortHashSet;
import gnu.trove.TShortIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TShortHashSetDecorator
extends AbstractSet<Short>
implements Set<Short> {
    protected TShortHashSet _set;

    public TShortHashSetDecorator(TShortHashSet set) {
        this._set = set;
    }

    public TShortHashSet getSet() {
        return this._set;
    }

    public TShortHashSetDecorator clone() {
        try {
            TShortHashSetDecorator copy = (TShortHashSetDecorator)super.clone();
            copy._set = (TShortHashSet)this._set.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean add(Short value2) {
        return this._set.add(this.unwrap(value2));
    }

    @Override
    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Short) {
                    short v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean remove(Object value2) {
        return this._set.remove(this.unwrap(value2));
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            private final TShortIterator it;
            {
                this.it = TShortHashSetDecorator.this._set.iterator();
            }

            @Override
            public Short next() {
                return TShortHashSetDecorator.this.wrap(this.it.next());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Short wrap(short k) {
        return new Short(k);
    }

    protected short unwrap(Object value2) {
        return (Short)value2;
    }
}

