/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongLongIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLongLongHashMapDecorator
extends AbstractMap<Long, Long>
implements Map<Long, Long>,
Cloneable {
    protected TLongLongHashMap _map;

    public TLongLongHashMapDecorator(TLongLongHashMap map2) {
        this._map = map2;
    }

    public TLongLongHashMap getMap() {
        return this._map;
    }

    @Override
    public TLongLongHashMapDecorator clone() {
        try {
            TLongLongHashMapDecorator copy = (TLongLongHashMapDecorator)super.clone();
            copy._map = (TLongLongHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Long put(Long key, Long value2) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value2)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Long && val instanceof Long) {
                    long k = this.unwrapKey(key);
                    long v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Long get(Long key) {
        long k = this.unwrapKey(key);
        long v = this._map.get(k);
        if (v == 0L) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Long remove(Long key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Long, Long>> entrySet() {
        return new AbstractSet<Map.Entry<Long, Long>>(){

            @Override
            public int size() {
                return TLongLongHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TLongLongHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TLongLongHashMapDecorator.this.containsKey(k) && ((Long)TLongLongHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Long, Long>> iterator() {
                return new Iterator<Map.Entry<Long, Long>>(){
                    private final TLongLongIterator it;
                    {
                        this.it = TLongLongHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Long, Long> next() {
                        this.it.advance();
                        final Long key = TLongLongHashMapDecorator.this.wrapKey(this.it.key());
                        final Long v = TLongLongHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Long, Long>(){
                            private Long val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Long getKey() {
                                return key;
                            }

                            @Override
                            public Long getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Long setValue(Long value2) {
                                this.val = value2;
                                return TLongLongHashMapDecorator.this.put(key, value2);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Long o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Long, Long>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TLongLongHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> map2) {
        Iterator<Map.Entry<? extends Long, ? extends Long>> it = map2.entrySet().iterator();
        int i = map2.size();
        while (i-- > 0) {
            Map.Entry<? extends Long, ? extends Long> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Long wrapKey(long k) {
        return new Long(k);
    }

    protected long unwrapKey(Object key) {
        return (Long)key;
    }

    protected Long wrapValue(long k) {
        return new Long(k);
    }

    protected long unwrapValue(Object value2) {
        return (Long)value2;
    }
}

