/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TDoubleObjectHashMap;
import gnu.trove.TDoubleObjectIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDoubleObjectHashMapDecorator<V>
extends AbstractMap<Double, V>
implements Map<Double, V>,
Cloneable {
    protected TDoubleObjectHashMap<V> _map;

    public TDoubleObjectHashMapDecorator(TDoubleObjectHashMap<V> map2) {
        this._map = map2;
    }

    public TDoubleObjectHashMap<V> getMap() {
        return this._map;
    }

    @Override
    public TDoubleObjectHashMapDecorator clone() {
        try {
            TDoubleObjectHashMapDecorator copy = (TDoubleObjectHashMapDecorator)super.clone();
            copy._map = this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public V put(Double key, V value2) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value2)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Double) {
                    double k = this.unwrapKey(key);
                    Object v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this._map.get(this.unwrapKey(key));
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public V remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Double, V>> entrySet() {
        return new AbstractSet<Map.Entry<Double, V>>(){

            @Override
            public int size() {
                return TDoubleObjectHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TDoubleObjectHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TDoubleObjectHashMapDecorator.this.containsKey(k) && TDoubleObjectHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Double, V>> iterator() {
                return new Iterator<Map.Entry<Double, V>>(){
                    private final TDoubleObjectIterator<V> it;
                    {
                        this.it = TDoubleObjectHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Double, V> next() {
                        this.it.advance();
                        final Double key = TDoubleObjectHashMapDecorator.this.wrapKey(this.it.key());
                        final Object v = TDoubleObjectHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Double, V>(){
                            private V val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Double getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public V setValue(V value2) {
                                this.val = value2;
                                return TDoubleObjectHashMapDecorator.this.put(key, value2);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Double, V> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Double, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TDoubleObjectHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends V> map2) {
        Iterator<Map.Entry<Double, V>> it = map2.entrySet().iterator();
        int i = map2.size();
        while (i-- > 0) {
            Map.Entry<Double, V> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Double wrapKey(double k) {
        return new Double(k);
    }

    protected double unwrapKey(Object key) {
        return (Double)key;
    }

    protected final V wrapValue(V o) {
        return o;
    }

    protected final V unwrapValue(V value2) {
        return value2;
    }
}

