/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntIterator;
import gnu.trove.TIntProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class TIntHashSet
extends TIntHash
implements Externalizable {
    static final long serialVersionUID = 1L;

    public TIntHashSet() {
    }

    public TIntHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TIntHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TIntHashSet(int[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TIntHashSet(TIntHashingStrategy strategy) {
        super(strategy);
    }

    public TIntHashSet(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TIntHashSet(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TIntHashSet(int[] array, TIntHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TIntIterator iterator() {
        return new TIntIterator(this);
    }

    public boolean add(int val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public int[] toArray() {
        int[] result2 = new int[this.size()];
        int[] set = this._set;
        byte[] states = this._states;
        int i = states.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            result2[j++] = set[i];
        }
        return result2;
    }

    public void clear() {
        super.clear();
        int[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntHashSet)) {
            return false;
        }
        final TIntHashSet that = (TIntHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TIntProcedure(){

            public final boolean execute(int value2) {
                return that.contains(value2);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(int val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsAll(int[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(int[] array) {
        boolean changed = false;
        Arrays.sort(array);
        int[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
            this.remove(set[i]);
            changed = true;
        }
        return changed;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size2 = in.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            int val = in.readInt();
            this.add(val);
        }
    }

    private final class HashProcedure
    implements TIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(int key) {
            this.h += TIntHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

