/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashIterator;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import gnu.trove.ToObjectArrayProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class THashSet<E>
extends TObjectHash<E>
implements Set<E>,
Iterable<E>,
Externalizable {
    static final long serialVersionUID = 1L;

    public THashSet() {
    }

    public THashSet(TObjectHashingStrategy<E> strategy) {
        super(strategy);
    }

    public THashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public THashSet(int initialCapacity, TObjectHashingStrategy<E> strategy) {
        super(initialCapacity, strategy);
    }

    public THashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public THashSet(int initialCapacity, float loadFactor, TObjectHashingStrategy<E> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public THashSet(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public THashSet(Collection<? extends E> collection, TObjectHashingStrategy<E> strategy) {
        this(collection.size(), strategy);
        this.addAll(collection);
    }

    @Override
    public boolean add(E obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        Object old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == FREE);
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll(that);
    }

    @Override
    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == FREE || oldSet[i] == REMOVED) continue;
            Object o = oldSet[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result2 = new Object[this.size()];
        this.forEach(new ToObjectArrayProcedure<Object>(result2));
        return result2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size2 = this.size();
        if (a.length < size2) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
        }
        this.forEach(new ToObjectArrayProcedure<T>(a));
        if (a.length > size2) {
            a[size2] = null;
        }
        return a;
    }

    @Override
    public void clear() {
        super.clear();
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = FREE;
        }
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.index(obj);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new TObjectHashIterator(this);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        int size2 = collection.size();
        this.ensureCapacity(size2);
        Iterator<E> it = collection.iterator();
        while (size2-- > 0) {
            if (!this.add(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        int size2 = collection.size();
        Iterator<?> it = collection.iterator();
        while (size2-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        int size2 = this.size();
        Iterator<E> it = this.iterator();
        while (size2-- > 0) {
            if (collection.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size2 = in.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            Object val = in.readObject();
            this.add(val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TObjectProcedure<E> {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(E key) {
            this.h += THashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

