/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.Vector;

public class WildCardFilter
implements FilenameFilter {
    String wildPattern = null;
    Vector pattern = new Vector();
    final String FIND = "find";
    final String EXPECT = "expect";
    final String ANYTHING = "anything";
    final String NOTHING = "nothing";

    public WildCardFilter(String wildString) {
        this.wildPattern = wildString;
        wildString = wildString.toLowerCase();
        int i = wildString.indexOf("**");
        while (i >= 0) {
            wildString = wildString.substring(0, i + 1) + wildString.substring(i + 2);
            i = wildString.indexOf("**");
        }
        StringTokenizer tokens = new StringTokenizer(wildString, "*", true);
        String token2 = null;
        while (tokens.hasMoreTokens()) {
            token2 = tokens.nextToken();
            if (token2.equals("*")) {
                this.pattern.addElement("find");
                if (tokens.hasMoreTokens()) {
                    token2 = tokens.nextToken();
                    this.pattern.addElement(token2);
                    continue;
                }
                this.pattern.addElement("anything");
                continue;
            }
            this.pattern.addElement("expect");
            this.pattern.addElement(token2);
        }
        if (!token2.equals("*")) {
            this.pattern.addElement("expect");
            this.pattern.addElement("nothing");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accept(File dir2, String name) {
        File tempFile;
        String path = dir2.getPath();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + File.separator;
        }
        if ((tempFile = new File(path, name)).isDirectory()) {
            return true;
        }
        name = name.toLowerCase();
        boolean acceptName = true;
        String command = null;
        String param2 = null;
        int currPos = 0;
        int cmdPos = 0;
        while (cmdPos < this.pattern.size()) {
            int nextPos;
            command = (String)this.pattern.elementAt(cmdPos);
            param2 = (String)this.pattern.elementAt(cmdPos + 1);
            if (command.equals("find")) {
                if (param2.equals("anything")) return acceptName;
                nextPos = name.indexOf(param2, currPos);
                if (nextPos < 0) return false;
                currPos = nextPos + param2.length();
            } else if (command.equals("expect")) {
                if (param2.equals("nothing")) {
                    if (currPos == name.length()) return acceptName;
                    return false;
                }
                nextPos = name.indexOf(param2, currPos);
                if (nextPos != currPos) {
                    return false;
                }
                currPos += param2.length();
            }
            cmdPos += 2;
        }
        return acceptName;
    }

    public String toString() {
        return this.wildPattern;
    }

    public String toPattern() {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < this.pattern.size()) {
            out.append("(");
            out.append((String)this.pattern.elementAt(i));
            out.append(" ");
            out.append((String)this.pattern.elementAt(i + 1));
            out.append(") ");
            i += 2;
        }
        return out.toString();
    }
}

