/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import dragon.util.EnvVariable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class FileUtil {
    public static BufferedReader getTextReader(String filename) {
        return FileUtil.getTextReader(new File(filename), null);
    }

    public static BufferedReader getTextReader(File file) {
        return FileUtil.getTextReader(file, null);
    }

    public static BufferedReader getTextReader(String filename, String charSet) {
        return FileUtil.getTextReader(new File(filename), charSet);
    }

    public static BufferedReader getTextReader(File file, String charSet) {
        try {
            if (charSet == null) {
                charSet = EnvVariable.getCharSet();
            }
            if (charSet == null) {
                return new BufferedReader(new FileReader(file));
            }
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charSet));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedWriter getTextWriter(String filename) {
        return FileUtil.getTextWriter(filename, false, null);
    }

    public static BufferedWriter getTextWriter(String filename, String charSet) {
        return FileUtil.getTextWriter(filename, false, charSet);
    }

    public static BufferedWriter getTextWriter(String filename, boolean append2) {
        return FileUtil.getTextWriter(filename, append2, null);
    }

    public static BufferedWriter getTextWriter(String filename, boolean append2, String charSet) {
        try {
            if (charSet == null) {
                charSet = EnvVariable.getCharSet();
            }
            if (charSet == null) {
                return new BufferedWriter(new FileWriter(filename, append2));
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append2), charSet));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean saveTextFile(String filename, String content) {
        return FileUtil.saveTextFile(filename, content, null);
    }

    public static boolean saveTextFile(String filename, String content, String charSet) {
        try {
            BufferedWriter out = FileUtil.getTextWriter(filename, charSet);
            out.write(content);
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String readTextFile(String filename) {
        return FileUtil.readTextFile(new File(filename), null);
    }

    public static String readTextFile(File file) {
        return FileUtil.readTextFile(file, null);
    }

    public static String readTextFile(String filename, String charSet) {
        return FileUtil.readTextFile(new File(filename), charSet);
    }

    public static String readTextFile(File file, String charSet) {
        int len = 0;
        int count2 = 128000;
        try {
            BufferedReader fr = FileUtil.getTextReader(file, charSet);
            char[] buf = new char[count2];
            StringBuffer str = new StringBuffer();
            len = fr.read(buf);
            while (true) {
                str.append(buf, 0, len);
                if (len < count2) break;
                len = fr.read(buf);
            }
            return str.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static PrintWriter getScreen() {
        try {
            String charSet = EnvVariable.getCharSet();
            if (charSet != null) {
                return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, charSet), true);
            }
            return new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PrintWriter getPrintWriter(String filename) {
        return FileUtil.getPrintWriter(filename, false, null);
    }

    public static PrintWriter getPrintWriter(String filename, boolean append2) {
        return FileUtil.getPrintWriter(filename, append2, null);
    }

    public static PrintWriter getPrintWriter(String filename, boolean append2, String charSet) {
        try {
            if (charSet == null) {
                charSet = EnvVariable.getCharSet();
            }
            if (charSet != null) {
                return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filename), append2), charSet));
            }
            return new PrintWriter(new FileOutputStream(new File(filename), append2));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getNewTempFilename(String folder, String prefix, String suffix) {
        File file;
        int i = 1;
        while ((file = new File(folder + prefix + String.valueOf(i) + "." + suffix)).exists()) {
            ++i;
        }
        return folder + prefix + String.valueOf(i) + "." + suffix;
    }

    public static String getNewTempFilename(String prefix, String suffix) {
        File file;
        int i = 1;
        while ((file = new File(prefix + String.valueOf(i) + "." + suffix)).exists()) {
            ++i;
        }
        return prefix + String.valueOf(i) + "." + suffix;
    }

    public static boolean exist(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public static long getSize(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public static void changeTextFileEncoding(String file, String oldEncoding, String newEncoding) {
        FileUtil.changeTextFileEncoding(new File(file), oldEncoding, newEncoding);
    }

    public static void changeTextFileEncoding(File file, String oldEncoding, String newEncoding) {
        try {
            if (file.isFile()) {
                if (!file.exists()) {
                    return;
                }
                FileUtil.saveTextFile(file.getAbsolutePath(), FileUtil.readTextFile(file, oldEncoding), newEncoding);
            } else {
                File[] subs = file.listFiles();
                int i = 0;
                while (i < subs.length) {
                    FileUtil.changeTextFileEncoding(subs[i], oldEncoding, newEncoding);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

