/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import dragon.util.FileUtil;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class DBUtil {
    public static void executeQuery(Connection con, String sql) {
        try {
            Statement st = con.createStatement();
            st.executeUpdate(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void executeBatchQuery(Connection con, String scriptFile) {
        try {
            String line;
            BufferedReader br = FileUtil.getTextReader(scriptFile);
            Statement st = con.createStatement();
            while ((line = br.readLine()) != null) {
                void var4_4;
                System.out.println((String)var4_4);
                st.executeUpdate((String)var4_4);
            }
            System.out.println("Done!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printResultSet(Connection con, String sql, PrintWriter out) {
        ResultSet rs = DBUtil.getResultSet(con, sql);
        DBUtil.printResultSet(rs, out);
        try {
            rs.close();
            rs.getStatement().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printResultSet(ResultSet rs, PrintWriter out) {
        DBUtil.printResultSet(rs, out, 0);
    }

    public static void printResultSet(ResultSet rs, PrintWriter out, int top) {
        try {
            int count2 = 0;
            ResultSetMetaData rsMeta = rs.getMetaData();
            int fieldNum = rsMeta.getColumnCount();
            while (rs.next() && (count2 < top || top <= 0)) {
                int i = 0;
                while (i < fieldNum) {
                    out.write(rs.getString(i + 1) + "\t");
                    ++i;
                }
                out.write("\n");
                out.flush();
                ++count2;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Connection getAccessCon(String file) {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String database = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=";
            database = database + file + ";DriverID=22;READONLY=true}";
            return DriverManager.getConnection(database, "", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Connection getMSSQLCon(String server, String db, String uid, String pwd) {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String database = "jdbc:odbc:Driver={SQL Server};Server=" + server;
            database = database + ";Database=" + db + ";UID=" + uid + ";PWD=" + pwd + ";";
            return DriverManager.getConnection(database, "", "");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Connection getMSSQL2000Con(String server, String db, String uid, String pwd) {
        try {
            Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            String database = "jdbc:microsoft:sqlserver://" + server + ":1433;";
            database = database + "databasename=" + db + ";user=" + uid + ";password=" + pwd + ";";
            return DriverManager.getConnection(database);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Connection getMSSQL2005Con(String server, String db, String uid, String pwd) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            String database = "jdbc:sqlserver://" + server + ":8081;";
            database = database + "databasename=" + db + ";user=" + uid + ";password=" + pwd + ";";
            return DriverManager.getConnection(database);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Connection getDB2Connection(String server, String db, String uid, String pwd) {
        String sConnect = "jdbc:db2://" + server + ":50000/" + db;
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
            Connection con = DriverManager.getConnection(sConnect, uid, pwd);
            return con;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void closeConnection(Connection con) {
        try {
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ResultSet getResultSet(Connection con, String sql) {
        try {
            Statement st = con.createStatement(1004, 1007);
            ResultSet rs = st.executeQuery(sql);
            return rs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getRecordCount(ResultSet rs) {
        if (rs == null) {
            return 0;
        }
        try {
            if (rs.getType() == 1003) {
                return 0;
            }
            int pos = rs.getRow();
            rs.last();
            int count2 = rs.getRow();
            if (pos == 0) {
                rs.first();
            } else {
                rs.absolute(pos);
            }
            return count2;
        }
        catch (SQLException e) {
            return 0;
        }
    }
}

