/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import dragon.util.ByteArrayConvert;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;

public class ByteArrayWriter
implements DataOutput {
    private ByteArrayOutputStream baos;

    public ByteArrayWriter(int capacity) {
        this.baos = new ByteArrayOutputStream(capacity);
    }

    public ByteArrayWriter() {
        this.baos = new ByteArrayOutputStream();
    }

    public void write(int value2) throws IOException {
        this.baos.write(value2);
    }

    public void writeByte(int value2) throws IOException {
        this.baos.write(value2);
    }

    public void writeBytes(String value2) throws IOException {
        this.baos.write(value2.getBytes());
    }

    public void writeBoolean(boolean value2) throws IOException {
        if (value2) {
            this.baos.write(1);
        } else {
            this.baos.write(0);
        }
    }

    public void writeChar(int value2) throws IOException {
        this.baos.write(ByteArrayConvert.toByte((char)value2));
    }

    public void writeChars(String value2) throws IOException {
        int len = value2.length();
        int i = 0;
        while (i < len) {
            this.baos.write(ByteArrayConvert.toByte(value2.charAt(i)));
            ++i;
        }
    }

    public void writeShort(int value2) throws IOException {
        this.baos.write(ByteArrayConvert.toByte((short)value2));
    }

    public void writeInt(int value2) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value2));
    }

    public void writeLong(long value2) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value2));
    }

    public void writeFloat(float value2) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value2));
    }

    public void writeDouble(double value2) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value2));
    }

    public void write(byte[] value2) throws IOException {
        this.baos.write(value2);
    }

    public void write(byte[] value2, int off, int len) throws IOException {
        this.baos.write(value2, off, len);
    }

    public void writeUTF(String value2) throws IOException {
        System.out.println("not implemented yet!");
    }

    public void reset() {
        this.baos.reset();
    }

    public int size() {
        return this.baos.size();
    }

    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    public void close() throws IOException {
        this.baos.close();
    }
}

