/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.BasicArticleIndex;
import dragon.onlinedb.BasicArticleParser;
import dragon.onlinedb.CollectionWriter;
import dragon.util.EnvVariable;
import java.io.File;
import java.io.RandomAccessFile;

public class BasicCollectionWriter
implements CollectionWriter {
    protected RandomAccessFile rafCollection;
    protected BasicArticleIndex articleIndex;
    protected ArticleParser parser;
    protected String charSet;

    public BasicCollectionWriter(String collectionFile, String indexFile, boolean append2) {
        try {
            this.charSet = EnvVariable.getCharSet();
            this.parser = new BasicArticleParser();
            if (!append2) {
                File file = new File(collectionFile);
                if (file.exists()) {
                    file.delete();
                }
                if ((file = new File(indexFile)).exists()) {
                    file.delete();
                }
            }
            this.rafCollection = new RandomAccessFile(collectionFile, "rw");
            if (this.rafCollection.length() > 0L) {
                this.rafCollection.seek(this.rafCollection.length());
            }
            this.articleIndex = new BasicArticleIndex(indexFile, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArticleParser getArticleParser() {
        return this.parser;
    }

    public void setArticleParser(ArticleParser parser) {
        this.parser = parser;
    }

    public boolean add(Article article) {
        try {
            if (article == null || article.getKey() == null) {
                return false;
            }
            if (!this.articleIndex.add(article.getKey(), this.rafCollection.getFilePointer())) {
                return false;
            }
            String line = this.parser.assemble(article);
            if (this.charSet != null) {
                this.rafCollection.write(line.getBytes(this.charSet));
            } else {
                this.rafCollection.write(line.getBytes());
            }
            if (line.charAt(line.length() - 1) != '\n') {
                this.rafCollection.writeByte(10);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        try {
            this.articleIndex.setCollectionFileSize(this.rafCollection.getFilePointer());
            this.rafCollection.close();
            this.articleIndex.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

