/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.nlp.compare.IndexSortable;

public class WordPairStat
implements IndexSortable,
Comparable {
    private int maxSpan;
    private int index;
    private int first;
    private int second;
    private int[] arrCount;
    private int totalCount;

    public WordPairStat(int first, int second, int maxSpan) {
        this.index = -1;
        this.maxSpan = maxSpan;
        this.first = first;
        this.second = second;
        this.arrCount = new int[2 * maxSpan];
        int i = 0;
        while (i < 2 * maxSpan) {
            this.arrCount[i] = 0;
            ++i;
        }
        this.totalCount = 0;
    }

    public WordPairStat(int index, int first, int second, int maxSpan) {
        this.index = index;
        this.first = first;
        this.second = second;
        this.maxSpan = maxSpan;
        this.arrCount = new int[2 * maxSpan];
        int i = 0;
        while (i < 2 * maxSpan) {
            this.arrCount[i] = 0;
            ++i;
        }
        this.totalCount = 0;
    }

    public WordPairStat copy() {
        WordPairStat stat = new WordPairStat(this.index, this.first, this.second, this.maxSpan);
        int i = 0;
        while (i < this.maxSpan) {
            stat.addFrequency(i - this.maxSpan, this.arrCount[i]);
            ++i;
        }
        i = 1;
        while (i <= this.maxSpan) {
            stat.addFrequency(i, this.arrCount[i + this.maxSpan - 1]);
            ++i;
        }
        return stat;
    }

    public void addFrequency(int span2, int inc) {
        if (span2 < 0) {
            int n = span2 + this.maxSpan;
            this.arrCount[n] = this.arrCount[n] + inc;
        } else {
            int n = span2 + this.maxSpan - 1;
            this.arrCount[n] = this.arrCount[n] + inc;
        }
        this.totalCount += inc;
    }

    public int getFrequency(int span2) {
        if (span2 > 0) {
            return this.arrCount[span2 + this.maxSpan - 1];
        }
        return this.arrCount[span2 + this.maxSpan];
    }

    public int getTotalFrequency() {
        return this.totalCount;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getFirstWord() {
        return this.first;
    }

    public void setFirstWord(int word) {
        this.first = word;
    }

    public int getSecondWord() {
        return this.second;
    }

    public void setSecondWord(int word) {
        this.second = word;
    }

    public int compareTo(Object obj) {
        int indexObj = ((WordPairStat)obj).getFirstWord();
        if (this.first == indexObj) {
            indexObj = ((WordPairStat)obj).getSecondWord();
            if (this.second == indexObj) {
                return 0;
            }
            if (this.second > indexObj) {
                return 1;
            }
            return -1;
        }
        if (this.first > indexObj) {
            return 1;
        }
        return -1;
    }
}

