/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.tool.xtract.WordPairGenerator;
import dragon.nlp.tool.xtract.WordPairStat;
import dragon.util.SortedArray;

public class EngWordPairGenerator
implements WordPairGenerator {
    protected int maxSpan;
    protected SortedArray list;

    public EngWordPairGenerator(int maxSpan) {
        this.maxSpan = maxSpan;
        this.list = new SortedArray();
    }

    public void setMaxSpan(int maxSpan) {
        this.maxSpan = maxSpan;
    }

    public int generate(Sentence sent) {
        this.list.clear();
        Word start = sent.getFirstWord();
        while (start != null) {
            if (start.getPOSIndex() != 1 && start.getPOSIndex() != 3) {
                start = start.next;
                continue;
            }
            Word end = start.next;
            int span2 = 1;
            while (end != null && span2 <= this.maxSpan) {
                int pos = end.getPOSIndex();
                if (pos == 1) {
                    WordPairStat curPair;
                    if (start.getIndex() <= end.getIndex()) {
                        curPair = new WordPairStat(start.getIndex(), end.getIndex(), this.maxSpan);
                        curPair.addFrequency(span2, 1);
                        if (!this.list.add(curPair)) {
                            curPair = (WordPairStat)this.list.get(this.list.insertedPos());
                            curPair.addFrequency(span2, 1);
                        }
                    } else {
                        curPair = new WordPairStat(end.getIndex(), start.getIndex(), this.maxSpan);
                        curPair.addFrequency(0 - span2, 1);
                        if (!this.list.add(curPair)) {
                            curPair = (WordPairStat)this.list.get(this.list.insertedPos());
                            curPair.addFrequency(0 - span2, 1);
                        }
                    }
                } else if (pos != 3) break;
                ++span2;
                end = end.next;
            }
            start = start.next;
        }
        return this.list.size();
    }

    public WordPairStat getWordPairs(int index) {
        return (WordPairStat)this.list.get(index);
    }
}

