/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.matrix.IntGiantSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.IntSuperSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.nlp.Token;
import dragon.nlp.compare.FrequencyComparator;
import dragon.nlp.tool.xtract.WordPairExpand;
import dragon.nlp.tool.xtract.WordPairStat;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class EngWordPairExpand
implements WordPairExpand {
    protected IntSparseMatrix sentMatrix;
    protected SimpleElementList wordList;
    protected int maxSpan;
    protected String indexFolder;
    protected IntSparseMatrix[] arrPairSentLeftMatrix;
    protected IntSparseMatrix[] arrPairSentRightMatrix;
    protected double threshold;

    public EngWordPairExpand(int maxSpan, String indexFolder, double threshold) {
        this.maxSpan = maxSpan;
        this.threshold = threshold;
        this.indexFolder = indexFolder;
        this.wordList = new SimpleElementList(indexFolder + "/wordkey.list", false);
        this.arrPairSentRightMatrix = new IntSparseMatrix[maxSpan];
        this.sentMatrix = new IntSuperSparseMatrix(indexFolder + "/sentencebase.index", indexFolder + "/sentencebase.matrix");
        int i = 1;
        while (i <= maxSpan) {
            this.arrPairSentRightMatrix[i - 1] = new IntGiantSparseMatrix(indexFolder + "/pairsentr" + i + ".index", indexFolder + "/pairsentr" + i + ".matrix");
            ++i;
        }
        this.arrPairSentLeftMatrix = new IntSparseMatrix[maxSpan];
        int i2 = 1;
        while (i2 <= maxSpan) {
            this.arrPairSentLeftMatrix[i2 - 1] = new IntGiantSparseMatrix(indexFolder + "/pairsentl" + i2 + ".index", indexFolder + "/pairsentl" + i2 + ".matrix");
            ++i2;
        }
    }

    public ArrayList expand(WordPairStat wordPairStat, int span2) {
        try {
            Token token2;
            int firstWord = wordPairStat.getFirstWord();
            int secondWord = wordPairStat.getSecondWord();
            String expandStr = null;
            ArrayList sentList = this.getSentenceList(wordPairStat, span2);
            int sentNum = sentList.size();
            boolean pass = true;
            if (span2 > 1 || span2 < -1) {
                token2 = span2 > 1 ? this.expandSecion(1, span2 - 1, sentNum, false, 0, sentList) : this.expandSecion(1, -span2 - 1, sentNum, true, 0, sentList);
                if (token2 == null) {
                    pass = false;
                } else {
                    pass = true;
                    sentList = (ArrayList)token2.getMemo();
                    expandStr = span2 > 1 ? this.getWordContent(firstWord) + " " + token2.getName().trim() + " " + this.getWordContent(secondWord) : this.getWordContent(secondWord) + " " + token2.getName().trim() + " " + this.getWordContent(firstWord);
                }
            } else {
                expandStr = span2 == 1 ? (this.getWordContent(firstWord) + " " + this.getWordContent(secondWord)).trim() : (this.getWordContent(secondWord).trim() + " " + this.getWordContent(firstWord)).trim();
            }
            if (!pass) {
                return null;
            }
            token2 = span2 > 0 ? this.expandSecion(1, this.maxSpan, sentNum, true, -1, sentList) : this.expandSecion(-span2 + 1, this.maxSpan - span2, sentNum, true, -1, sentList);
            if (token2 != null) {
                sentList = (ArrayList)token2.getMemo();
                expandStr = token2.getName().trim() + " " + expandStr;
            }
            if ((token2 = span2 > 0 ? this.expandSecion(span2 + 1, span2 + this.maxSpan, sentNum, false, 1, sentList) : this.expandSecion(1, this.maxSpan, sentNum, false, 1, sentList)) != null) {
                sentList = (ArrayList)token2.getMemo();
                expandStr = expandStr + " " + token2.getName().trim();
            }
            ArrayList<Token> phraseList = new ArrayList<Token>(1);
            phraseList.add(new Token(expandStr.trim()));
            return phraseList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ArrayList getSentenceList(WordPairStat wordPairStat, int span2) {
        int pairIndex = wordPairStat.getIndex();
        int firstWord = wordPairStat.getFirstWord();
        int secondWord = wordPairStat.getSecondWord();
        IntSparseMatrix pairSentMatrix = span2 < 0 ? this.arrPairSentLeftMatrix[-span2 - 1] : this.arrPairSentRightMatrix[span2 - 1];
        int sentNum = pairSentMatrix.getNonZeroNumInRow(pairIndex);
        ArrayList<Token> sentList = new ArrayList<Token>(sentNum);
        int i = 0;
        while (i < sentNum) {
            int sentIndex = pairSentMatrix.getNonZeroColumnInRow(pairIndex, i);
            int sentLength = this.sentMatrix.getNonZeroNumInRow(sentIndex);
            int j = 0;
            while (j < sentLength) {
                int wordKey = this.sentMatrix.getNonZeroColumnInRow(sentIndex, j);
                if (wordKey == firstWord) {
                    if (j + span2 < 0 || j + span2 >= sentLength || this.sentMatrix.getNonZeroColumnInRow(sentIndex, j + span2) != secondWord) break;
                    Token sentToken = new Token(String.valueOf(sentIndex));
                    sentToken.setIndex(j);
                    sentToken.setFrequency(this.sentMatrix.getNonZeroIntScoreInRow(sentIndex, j + span2));
                    sentList.add(sentToken);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return sentList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token expandSecion(int start, int end, int sentNum, boolean inverse, int direction, ArrayList sentList) {
        Token token2;
        String expandStr = "";
        String marginalWord = null;
        int marginalPOS = -1;
        int i = start;
        while (i <= end) {
            int j = inverse ? -i : i;
            token2 = this.checkSentPos(j, sentList);
            if (token2 == null) break;
            sentList = (ArrayList)token2.getMemo();
            if (!((double)token2.getFrequency() / (double)sentNum >= this.threshold)) break;
            String word = this.getWordContent(Integer.parseInt(token2.getName()));
            int posIndex = token2.getIndex();
            if (direction != 0 && !this.checkValidation(word, posIndex)) break;
            expandStr = inverse ? word + " " + expandStr : expandStr + " " + word;
            expandStr = expandStr.trim();
            if (direction == 1 && !inverse || direction == -1 && inverse) {
                marginalWord = word;
                marginalPOS = posIndex;
            }
            ++i;
        }
        if (i <= end && direction == 0) {
            return null;
        }
        if (expandStr.equals("")) return null;
        if (direction == 1 && !inverse && !this.checkEndingWordValidation(marginalWord, marginalPOS)) {
            int pos = expandStr.lastIndexOf(32);
            if (pos < 0) return null;
            expandStr = expandStr.substring(0, pos);
        } else if (direction == -1 && inverse && !this.checkStartingWordValidation(marginalWord, marginalPOS)) {
            int pos = expandStr.indexOf(32);
            if (pos < 0) return null;
            expandStr = expandStr.substring(pos + 1);
        }
        token2 = new Token(expandStr);
        token2.setMemo(sentList);
        return token2;
    }

    protected Token checkSentPos(int spanFromFirstWord, ArrayList sentList) {
        Token wordToken;
        SortedArray tokenList = new SortedArray();
        int i = 0;
        while (i < sentList.size()) {
            Token sentToken = (Token)sentList.get(i);
            int sentIndex = Integer.parseInt(sentToken.getName());
            int sentLength = this.sentMatrix.getNonZeroNumInRow(sentIndex);
            int firstWordPos = sentToken.getIndex();
            if (firstWordPos + spanFromFirstWord >= 0 && firstWordPos + spanFromFirstWord < sentLength) {
                ArrayList sList;
                int wordKey = this.sentMatrix.getNonZeroColumnInRow(sentIndex, firstWordPos + spanFromFirstWord);
                wordToken = new Token(String.valueOf(wordKey));
                int tokenIndex = tokenList.binarySearch(wordToken);
                if (tokenIndex < 0) {
                    sList = new ArrayList();
                    sList.add(sentToken);
                    wordToken.setFrequency(1);
                    wordToken.setIndex(this.sentMatrix.getNonZeroIntScoreInRow(sentIndex, firstWordPos + spanFromFirstWord));
                    wordToken.setMemo(sList);
                    tokenList.add(wordToken);
                } else {
                    wordToken = (Token)tokenList.get(tokenIndex);
                    wordToken.addFrequency(1);
                    sList = (ArrayList)wordToken.getMemo();
                    sList.add(sentToken);
                }
            }
            ++i;
        }
        if (tokenList.size() > 0) {
            tokenList.setComparator(new FrequencyComparator(true));
            wordToken = (Token)tokenList.get(0);
            tokenList.clear();
            return wordToken;
        }
        return null;
    }

    protected String getWordContent(int index) {
        return this.wordList.search(index).trim();
    }

    protected boolean checkValidation(String word, int posIndex) {
        return posIndex == 3 || posIndex == 1 || posIndex == 0 && word.equals("-");
    }

    protected boolean checkEndingWordValidation(String word, int posIndex) {
        return posIndex == 1;
    }

    protected boolean checkStartingWordValidation(String word, int posIndex) {
        return posIndex == 1 || posIndex == 3;
    }
}

