/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.lemmatiser;

import dragon.nlp.tool.lemmatiser.Operation;

public class SuffixDetachOperation
implements Operation {
    private String suffix;
    private String changeTo;
    private int pos;
    private boolean indexLookupOption;

    SuffixDetachOperation(int POS2, String suffix, String changeTo) {
        this.pos = POS2;
        this.suffix = suffix;
        this.changeTo = changeTo;
        this.indexLookupOption = false;
    }

    public String execute(String derivation) {
        if (derivation.length() > this.suffix.length() && derivation.endsWith(this.suffix)) {
            if (this.changeTo == null) {
                return derivation.substring(0, derivation.length() - this.suffix.length());
            }
            return derivation.substring(0, derivation.length() - this.suffix.length()) + this.changeTo;
        }
        return null;
    }

    public boolean getIndexLookupOption() {
        return this.indexLookupOption;
    }

    public void setIndexLookupOption(boolean option) {
        this.indexLookupOption = option;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getChangeTo() {
        return this.changeTo;
    }

    public int getPOSIndex() {
        return this.pos;
    }
}

