/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.lemmatiser;

import dragon.nlp.tool.lemmatiser.Operation;
import dragon.nlp.tool.lemmatiser.WordMap;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.util.ArrayList;

public class ExceptionOperation
implements Operation {
    SortedArray wordList;
    int pos;

    public ExceptionOperation(int POS2, String exceptionFile) {
        this.pos = POS2;
        this.wordList = this.loadExceptions(exceptionFile);
    }

    public boolean getIndexLookupOption() {
        return false;
    }

    public int getPOSIndex() {
        return this.pos;
    }

    public String execute(String derivation) {
        int index = this.wordList.binarySearch(new WordMap(derivation, null));
        if (index >= 0) {
            WordMap wordMap = (WordMap)this.wordList.get(index);
            if (wordMap.getSlaveWord() == null || wordMap.getSlaveWord().length() == 0) {
                return wordMap.getMasterWord();
            }
            return wordMap.getSlaveWord();
        }
        return null;
    }

    private SortedArray loadExceptions(String filename) {
        try {
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            ArrayList<WordMap> list2 = new ArrayList<WordMap>(total);
            int i = 0;
            while (i < total) {
                line = br.readLine();
                String[] arrField = line.split(" ");
                WordMap cur = arrField.length >= 2 ? new WordMap(arrField[0], arrField[1]) : new WordMap(arrField[0], null);
                list2.add(cur);
                ++i;
            }
            br.close();
            SortedArray exceptionlist = new SortedArray();
            exceptionlist.addAll(list2);
            return exceptionlist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

