/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.WordNetUtil;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import java.io.FileInputStream;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.Dictionary;

public class WordNetDidion
implements Lemmatiser,
WordNetUtil {
    private Dictionary dict;

    public WordNetDidion(String workDir) {
        try {
            String propsFile;
            if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
                workDir = EnvVariable.getDragonHome() + "/" + workDir;
            }
            if (!this.checkDataDirectory(propsFile = workDir + "/file_properties.xml", workDir)) {
                System.out.println("The wordnet data directory is not correct!");
                return;
            }
            JWNL.initialize(new FileInputStream(propsFile));
            this.dict = Dictionary.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WordNetDidion() {
        this(EnvVariable.getDragonHome() + "/nlpdata/wordnet");
    }

    public Dictionary getDictionary() {
        return this.dict;
    }

    public String lemmatize(String word) {
        if (Character.isDigit(word.charAt(word.length() - 1))) {
            return word;
        }
        int i = 1;
        while (i <= 4) {
            try {
                IndexWord indexWord = this.dict.lookupIndexWord(this.getPOS(i), word);
                if (indexWord != null) {
                    return indexWord.getLemma();
                }
            }
            catch (JWNLException ex) {
                ex.printStackTrace();
                return null;
            }
            ++i;
        }
        return word;
    }

    public String lemmatize(String word, int pos) {
        if (Character.isDigit(word.charAt(word.length() - 1))) {
            return word;
        }
        if (pos > 4 || pos < 1) {
            return word;
        }
        try {
            IndexWord indexWord = this.dict.lookupIndexWord(this.getPOS(pos), word);
            if (indexWord != null) {
                return indexWord.getLemma();
            }
            return word;
        }
        catch (JWNLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String stem(String word) {
        return this.lemmatize(word);
    }

    private POS getPOS(int index) {
        switch (index) {
            case 1: {
                return POS.NOUN;
            }
            case 2: {
                return POS.VERB;
            }
            case 3: {
                return POS.ADJECTIVE;
            }
            case 4: {
                return POS.ADVERB;
            }
        }
        return null;
    }

    private boolean checkDataDirectory(String propsFile, String dataDir) {
        try {
            String content = FileUtil.readTextFile(propsFile);
            int start = content.indexOf("dictionary_path");
            start = content.indexOf("value=", start) + 7;
            int end = content.indexOf("\"", start);
            if (content.substring(start, end).equals(dataDir)) {
                return true;
            }
            content = content.substring(0, start) + dataDir + content.substring(end);
            return FileUtil.saveTextFile(propsFile, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

